/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.common.base.Objects;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.NotificationScheme;
import com.urbancode.release.rest.models.RecurringDeployment;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.Version;
import com.urbancode.release.rest.models.internal.ApprovalSet;
import com.urbancode.release.rest.models.internal.ApprovalTemplate;
import com.urbancode.release.rest.models.internal.CheckpointPlan;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.DeploymentExecutionUpdate;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.FederatedDeployment;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.RelatedDeployment;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ScheduledDeploymentVersion;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.SegmentPlan;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskExecution;
import com.urbancode.release.rest.models.internal.TaskPlan;
import com.urbancode.release.rest.models.internal.TaskTag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScheduledDeployment
extends ClientEntity<ScheduledDeployment> {
    public String description;
    public Long scheduledDate;
    public Long endTimeOverride;
    public Long completionTimeOverride;
    public Release release;
    public Phase phase;
    public ReleaseEnvironment environment;
    public Role role;
    public ApprovalSet approval;
    public DeploymentPlan deploymentPlan;
    public RecurringDeployment rule;
    public Boolean autoPickVersions;
    public Boolean autoStart;
    public Boolean autoManualTaskNotification;
    public Boolean regexPattern;
    public String pattern;
    public NotificationScheme notificationScheme;
    public String statusState;
    public String statusText;
    public String versionId;
    public Boolean deleteEndTimeOverride;
    @JsonReadOnly
    public String status;
    @JsonReadOnly
    public String gateStatus;
    @JsonReadOnly
    public String shortName;
    @JsonReadOnly
    public String derivedName;
    @JsonReadOnly
    public Long cacheVersionStructure;
    @JsonReadOnly
    public Long cacheVersionStatus;
    @JsonReadOnly
    public User creator;
    @JsonReadOnly
    public User executingUserId;
    @JsonReadOnly
    public String executingUser;
    @JsonReadOnly
    public ScheduledDeploymentVersion[] versions;
    @JsonReadOnly
    public Boolean projectedVersions;
    @JsonReadOnly
    public Version[] selectedVersions;
    @JsonReadOnly
    public Version[] autoSelectedVersions;
    @JsonReadOnly
    public DeploymentExecution deploymentExecution;
    @JsonReadOnly
    public Application[] notApplicableApplications;
    @JsonReadOnly
    public FederatedDeployment[] federatedDeployments;
    @JsonReadOnly
    public RelatedDeployment relatedDeployment;
    @JsonReadOnly
    public int version;
    private int defaultWaitTime;
    private int defaultRetryAttempts;
    @JsonReadOnly
    public Phase[] phases;
    public DeploymentExecutionUpdate update;

    public ScheduledDeployment() {
        this.path = "/scheduledDeployments/";
        this.oldPath = "/scheduledDeployment/";
        this.writeToOldPath = true;
        this.defaultWaitTime = 1000;
        this.defaultRetryAttempts = 10;
    }

    @Deprecated
    public ScheduledDeployment getRefreshedCache(String format) throws InterruptedException {
        long cacheVersion = 0L;
        if (format.equals(CacheFormats.StructureFormat.toString())) {
            cacheVersion = this.cacheVersionStructure;
        } else if (format.equals(CacheFormats.StatusFormat.toString())) {
            cacheVersion = this.cacheVersionStatus;
        }
        this.format("detail");
        log.debug("get()");
        for (int i = 0; i < this.defaultRetryAttempts; ++i) {
            try {
                ScheduledDeployment sd = (ScheduledDeployment)this.getResponse().as(this.modelClass(), ObjectMapperType.GSON);
                if (!(format.equals(CacheFormats.StructureFormat.name) ? sd.cacheVersionStructure > cacheVersion : format.equals(CacheFormats.StatusFormat.name) && sd.cacheVersionStatus > cacheVersion)) continue;
                return sd;
            }
            catch (AssertionError e) {
                Thread.sleep(this.defaultWaitTime);
                continue;
            }
            catch (Exception e) {
                Thread.sleep(this.defaultWaitTime);
            }
        }
        return (ScheduledDeployment)this.getResponse().as(this.modelClass(), ObjectMapperType.GSON);
    }

    public Long getScheduledDate() {
        return this.scheduledDate;
    }

    public Long getEndTimeOverride() {
        return this.endTimeOverride;
    }

    public DeploymentExecution getDeploymentExecution() {
        return this.deploymentExecution;
    }

    public String getStatus() {
        return this.status;
    }

    public Release getRelease() {
        return this.release;
    }

    public NotificationScheme getNotificationScheme() {
        return this.notificationScheme;
    }

    public ScheduledDeployment notificationScheme(NotificationScheme scheme) {
        this.notificationScheme = scheme;
        return this;
    }

    public ScheduledDeployment scheduledDate(Long scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    public ScheduledDeployment endTimeOverride(Long endTimeOverride) {
        this.endTimeOverride = endTimeOverride;
        return this;
    }

    public ScheduledDeployment completionTimeOverride(Long completionTimeOverride) {
        this.completionTimeOverride = completionTimeOverride;
        return this;
    }

    public ScheduledDeployment release(Release release) {
        this.handleNull(release, "release");
        this.release = release;
        return this;
    }

    public ScheduledDeployment phase(Phase phase) {
        this.handleNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    public ScheduledDeployment environment(ReleaseEnvironment environment) {
        this.handleNull(environment, "environment");
        this.environment = environment;
        return this;
    }

    public ScheduledDeployment role(Role role) {
        this.handleNull(role, "role");
        this.role = role;
        return this;
    }

    public ScheduledDeployment deploymentPlan(DeploymentPlan deploymentPlan) {
        this.handleNull(deploymentPlan, "deploymentPlan");
        this.deploymentPlan = deploymentPlan;
        return this;
    }

    public ScheduledDeployment deleteEndTimeOverride(boolean deleteEndTimeOverride) {
        this.deleteEndTimeOverride = deleteEndTimeOverride;
        return this;
    }

    @Override
    public Response delete() {
        log.debug("delete()");
        return (Response)this.query.apply(RestAssured.given()).delete(this.path(this.id), new Object[0]);
    }

    public ScheduledDeployment addVersion(Version version) {
        RestAssured.given().post(this.path(this.id) + "/version/" + version.id, new Object[0]);
        return this;
    }

    public ScheduledDeployment addVersions(Version ... versions) {
        JsonArray versionIds = new JsonArray();
        for (Version version : versions) {
            versionIds.add(new JsonPrimitive(version.getId()));
        }
        RestAssured.given().body(versionIds.toString()).put(this.path(this.id) + "/addVersions", new Object[0]);
        return this;
    }

    public ScheduledDeployment removeVersion(Version version) {
        RestAssured.given().delete(this.path(this.id) + "/version/" + version.id, new Object[0]);
        return this;
    }

    public ScheduledDeployment removeVersions(Version ... versions) {
        JsonArray versionIds = new JsonArray();
        for (Version version : versions) {
            versionIds.add(new JsonPrimitive(version.getId()));
        }
        RestAssured.given().body(versionIds.toString()).delete(this.path(this.id) + "/removeVersions", new Object[0]);
        return this;
    }

    public boolean hasVersion(Version version) {
        for (ScheduledDeploymentVersion sdVersion : this.versions) {
            if (!sdVersion.appVersion.id.equals(version.id)) continue;
            return true;
        }
        return false;
    }

    public void updateDeploymentStatus(StatusState state, String message) {
        JsonObject statusObject = new JsonObject();
        statusObject.addProperty("statusState", state.toString());
        statusObject.addProperty("statusText", message);
        RestAssured.given().body(statusObject.toString()).put(this.path(this.id) + "/updateStatus", new Object[0]);
        this.statusState = state.toString();
        this.statusText = message;
    }

    public ScheduledDeployment excludeApplication(Version version) {
        RestAssured.given().post(this.oldPath(this.id) + "/version/" + version.id + "/exclude", new Object[0]);
        return this;
    }

    public ScheduledDeployment createReleaseVersion(String name) {
        RestAssured.given().body(String.format("{\"name\":\"%s\"}", name)).put(this.oldPath(this.id) + "/snapshot", new Object[0]);
        return this;
    }

    public ScheduledDeployment execute() {
        RestAssured.given().put(this.path(this.id) + "/execute", new Object[0]);
        return this;
    }

    public ScheduledDeployment abort() {
        RestAssured.given().put(this.path(this.id) + "/abort", new Object[0]);
        return this;
    }

    public ScheduledDeployment reopen() {
        RestAssured.given().put(this.path(this.id) + "/reopen", new Object[0]);
        return this;
    }

    public static List<ScheduledDeployment> getDeploymentsForReleasePhaseEnvironment(Release r, Phase p, ReleaseEnvironment e) {
        ArrayList<ScheduledDeployment> result = new ArrayList<ScheduledDeployment>();
        for (ScheduledDeployment sd : (ScheduledDeployment[])InternalClients.scheduledDeployment().getAll()) {
            if (!sd.release.id.equals(r.id) || !sd.phase.id.equals(p.id) || !sd.environment.id.equals(e.id)) continue;
            result.add(sd);
        }
        return result;
    }

    @Deprecated
    public DeploymentExecutionUpdate getUpdate() {
        DeploymentExecutionUpdate result;
        this.update = result = ((DeploymentExecutionUpdate)InternalClients.deploymentExecutionUpdate().id(this.id)).scheduledDeployment(this).getUpdate();
        return result;
    }

    public UpdateFormat getUpdateFormat() {
        return ((Response)RestAssured.given().param("format", "update").get("/scheduledDeployments/" + this.id, new Object[0])).as(UpdateFormat.class, ObjectMapperType.GSON);
    }

    public static ScheduledDeploymentDataGenerator getDataGenerator() {
        return new ScheduledDeploymentDataGenerator();
    }

    public static class ScheduledDeploymentDataGenerator
    extends ClientEntity.DataGenerator<ScheduledDeployment> {
        public static final Map<String, String[]> rolesToUsers;
        public static final String[][][] taskNames;

        public ScheduledDeployment provisionSimpleDeployment(Release release, ReleaseEnvironment env) {
            return this.provisionSimpleDeployment(release, env, null);
        }

        public ScheduledDeployment provisionSimpleDeployment(Release release, ReleaseEnvironment env, Application app) {
            return this.provisionSimpleDeployment(release, env, app, null);
        }

        public ScheduledDeployment provisionSimpleDeployment(Release release, ReleaseEnvironment env, Application app, Integer phaseIndex) {
            if (((Release)release.get()).phases.length == 0) {
                throw new RuntimeException("The Release must have at least one phase to use provisionSimpleDeployment");
            }
            if (app != null) {
                release.addApplication(app);
            }
            Phase phase = phaseIndex == null ? release.phases[0] : release.phases[phaseIndex];
            Clients.environmentReservation().startDate(946702800000L).endDate(4102462800000L).environment(env).phase(phase).save();
            return (ScheduledDeployment)InternalClients.scheduledDeployment().release(release).phase(phase).environment(env).deploymentPlan(phase.deploymentPlan).scheduledDate(1402517280000L).save();
        }

        public ScheduledDeployment provisionSimpleDeployment(String newReleaseName, ReleaseEnvironment env, String newAppName) {
            return this.provisionSimpleDeployment(newReleaseName, env, newAppName, null);
        }

        public ScheduledDeployment provisionSimpleDeployment(String newReleaseName, ReleaseEnvironment env, String newAppName, Integer phaseIndex) {
            Long oneMonth = 2764800000L;
            return this.provisionSimpleDeployment((Release)((Release)Clients.release().defaults().targetDate(System.currentTimeMillis() + oneMonth).name(newReleaseName)).save(), env, (Application)((Application)Clients.application().name(newAppName)).releaseEnvironments(env).teams(Team.SAMPLE_TEAM).save(), phaseIndex);
        }

        public ScheduledDeployment provisionSimpleDeploymentWithVersion(String newReleaseName, ReleaseEnvironment env, String newAppName, String newVersionName) {
            ScheduledDeployment sd = this.provisionSimpleDeployment(newReleaseName, env, newAppName);
            return sd.addVersion((Version)((Version)Clients.version().name(newVersionName)).application(sd.release.baseApplication.children[0]).save());
        }

        public ScheduledDeployment provisionSimpleDeploymentWithVersion(Release release, ReleaseEnvironment env, Application app, Version version) {
            return this.provisionSimpleDeployment(release, env, app).addVersion(version);
        }

        public ScheduledDeployment provisionSimpleDeploymentWithSegmentsAndTasks(String newReleaseName, ReleaseEnvironment env, String newAppName, int numSegments, int numTasksPerSegment) {
            ScheduledDeployment sd = this.provisionSimpleDeployment(newReleaseName, env, newAppName);
            return this.addSegmentsAndTasks(sd, null, numSegments, numTasksPerSegment, false);
        }

        public ScheduledDeployment provisionSimpleDeploymentWithSegmentsAndTasks(Release release, ReleaseEnvironment env, Application app, int numSegments, int numTasksPerSegment) {
            ScheduledDeployment sd = this.provisionSimpleDeployment(release, env, app);
            return this.addSegmentsAndTasks(sd, app, numSegments, numTasksPerSegment, true);
        }

        private ScheduledDeployment addSegmentsAndTasks(ScheduledDeployment sd, Application app, int numSegments, int numTasksPerSegment, boolean tasksOnApplication) {
            int i;
            DeploymentPlan dp = ((ScheduledDeployment)sd.get()).deploymentExecution.deploymentPlan;
            SegmentExecution[] segs = ((DeploymentExecution)sd.deploymentExecution.get()).segments;
            for (i = 0; i < segs.length; ++i) {
                segs[i].delete();
            }
            for (i = 0; i < numSegments; ++i) {
                SegmentPlan seg = (SegmentPlan)((SegmentPlan)((SegmentPlan)InternalClients.segmentPlan().name("Segment " + i)).executionPattern("PARALLEL")).deploymentPlan(dp).save();
                for (int j = 0; j < numTasksPerSegment; ++j) {
                    TaskPlan taskPlan = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.ManualTask)).executorRoleOrGroup(Role.ADMIN)).name(String.format("Task " + j + "Seg " + i, new Object[0]))).duration(5L)).application(app)).save();
                    seg.addTask(taskPlan);
                }
            }
            return sd;
        }

        public ScheduledDeployment provisionRandomDeployment(ScheduledDeployment sd, int minDurationMinutes, int minTaskDuration, int maxTaskDuration, int approxTasksPerSeg) {
            HashMap<String, Role> roleNameToRole = new HashMap<String, Role>();
            HashMap roleNameToUsers = new HashMap();
            for (String roleName : rolesToUsers.keySet()) {
                roleNameToRole.put(roleName, Role.getOrCreateByName(roleName));
                roleNameToUsers.put(roleName, new ArrayList());
                for (String userName : rolesToUsers.get(roleName)) {
                    ((List)roleNameToUsers.get(roleName)).add(User.getOrCreateByName(userName));
                }
            }
            TaskTag[] potentialTags = new TaskTag[]{TaskTag.getOrCreateByName("Critical Task", "#cc0000"), TaskTag.getOrCreateByName("Networking Task", "#009933"), TaskTag.getOrCreateByName("Communication Task", "#ffcc66"), TaskTag.getOrCreateByName("Exec", "#6600ff"), TaskTag.getOrCreateByName("Operations", "#669999"), TaskTag.getOrCreateByName("Database Admin", "#66ffcc"), TaskTag.getOrCreateByName("Release Management", "#ff6699")};
            Double[] tagsProbability = new Double[]{0.05, 0.1, 0.15, 0.1, 0.3, 0.25, 0.35};
            DeploymentPlan dp = ((ScheduledDeployment)sd.get()).deploymentExecution.deploymentPlan;
            SegmentExecution[] segs = ((DeploymentExecution)sd.deploymentExecution.get()).segments;
            for (int i = 0; i < segs.length; ++i) {
                segs[i].delete();
            }
            ArrayList<SegmentPlan> preReqSegmentPlans = new ArrayList<SegmentPlan>();
            int segNum = 0;
            double parallelProb = 0.5;
            double segmentPreqProb = 0.8;
            while ((sd.deploymentExecution.endTimePlanned - sd.scheduledDate) / 60000L < (long)minDurationMinutes) {
                int numTasksInSeg;
                SegmentPlan seg = (SegmentPlan)((SegmentPlan)((SegmentPlan)InternalClients.segmentPlan().name("Segment " + segNum)).executionPattern(Math.random() < parallelProb ? "PARALLEL" : "SEQUENTIAL")).deploymentPlan(dp).save();
                if (segNum > 0) {
                    if (Math.random() < segmentPreqProb) {
                        seg.prerequisites((SegmentPlan)preReqSegmentPlans.get(preReqSegmentPlans.size() - 1)).save();
                        preReqSegmentPlans.add(seg);
                    }
                } else {
                    preReqSegmentPlans.add(seg);
                }
                if ((numTasksInSeg = (int)((double)approxTasksPerSeg * (1.0 + (Math.random() - 0.5) / 2.0))) <= 0) {
                    numTasksInSeg = 1;
                }
                for (int i = 0; i < numTasksInSeg; ++i) {
                    int y;
                    Long taskDuration = new Long(minTaskDuration + (int)(Math.random() * (double)(maxTaskDuration - minTaskDuration)));
                    ArrayList<TaskTag> tags = new ArrayList<TaskTag>();
                    for (int j = 0; j < potentialTags.length; ++j) {
                        if (!(Math.random() < tagsProbability[j])) continue;
                        tags.add(potentialTags[j]);
                    }
                    TaskTag[] tagsArray = new TaskTag[tags.size()];
                    for (int j = 0; j < tags.size(); ++j) {
                        tagsArray[j] = (TaskTag)tags.get(j);
                    }
                    int x = segNum;
                    if (x >= taskNames.length) {
                        x = taskNames.length - 1 - segNum % taskNames.length;
                    }
                    if ((y = i) >= taskNames[x].length) {
                        y = segNum % taskNames[x].length;
                    }
                    TaskPlan taskPlan = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.ManualTask)).executorRoleOrGroup((Role)roleNameToRole.get(taskNames[x][y][1]))).user((User)((List)roleNameToUsers.get(taskNames[x][y][1])).get((int)(Math.random() * 2.0)))).name(taskNames[x][y][0])).duration(taskDuration)).taskTags(tagsArray)).save();
                    seg.addTask(taskPlan);
                }
                ++segNum;
                sd = (ScheduledDeployment)sd.get();
                if (sd.deploymentExecution.endTimePlanned != null) continue;
                sd.deploymentExecution.invalidateCache();
                sd = (ScheduledDeployment)sd.get();
            }
            return sd;
        }

        public ScheduledDeployment provisionSimpleDeploymentWithSegmentsAndTasks(Release release, ReleaseEnvironment env, int numSegments, int numTasksPerSegment) {
            int i;
            ScheduledDeployment sd = this.provisionSimpleDeployment(release, env);
            DeploymentPlan dp = ((ScheduledDeployment)sd.get()).deploymentExecution.deploymentPlan;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            SegmentExecution[] segs = ((DeploymentExecution)sd.deploymentExecution.get()).segments;
            for (i = 0; i < segs.length; ++i) {
                segs[i].delete();
            }
            for (i = 0; i < numSegments; ++i) {
                SegmentPlan seg = (SegmentPlan)((SegmentPlan)((SegmentPlan)InternalClients.segmentPlan().name("Segment " + i)).executionPattern("PARALLEL")).deploymentPlan(dp).save();
                for (int j = 0; j < numTasksPerSegment; ++j) {
                    TaskPlan taskPlan = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.ManualTask)).executorRoleOrGroup(Role.ADMIN)).name(String.format("Task " + j + "Seg " + i, new Object[0]))).duration(5L)).save();
                    seg.addTask(taskPlan);
                }
            }
            return sd;
        }

        public ScheduledDeployment provisionSimpleDeploymentWithSegmentsAndTasksWithSignalsAndWaits(String newReleaseName, ReleaseEnvironment env, String newAppName, int numManualTasksPerSegment, List<CheckpointPlan> plans, boolean firstSegmentSignal) {
            ScheduledDeployment sd = this.provisionSimpleDeployment(newReleaseName, env, newAppName);
            DeploymentPlan dp = ((ScheduledDeployment)sd.get()).deploymentExecution.deploymentPlan;
            SegmentExecution[] segs = ((DeploymentExecution)sd.deploymentExecution.get()).segments;
            for (int i = 0; i < segs.length; ++i) {
                segs[i].delete();
            }
            ArrayList<TaskPlan> tasks = new ArrayList<TaskPlan>();
            HashMap tasksToSegment = new HashMap();
            ArrayList<SegmentPlan> segments = new ArrayList<SegmentPlan>();
            SegmentPlan previousSeg = null;
            for (int i = 0; i < plans.size(); ++i) {
                TaskPlan tp;
                ArrayList<TaskPlan> arrayList = new ArrayList<TaskPlan>();
                SegmentPlan seg = ((SegmentPlan)((SegmentPlan)InternalClients.segmentPlan().name("Segment " + i)).executionPattern("SEQUENTIAL")).deploymentPlan(dp);
                segments.add(seg);
                for (int j = 0; j < numManualTasksPerSegment; ++j) {
                    TaskPlan taskPlan = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.ManualTask)).executorRoleOrGroup(Role.ADMIN)).name(String.format("Task " + j + "Seg " + i, new Object[0]))).duration(5L);
                    tasks.add(taskPlan);
                    arrayList.add(taskPlan);
                }
                if (firstSegmentSignal) {
                    tp = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.SignalTask)).checkpointPlan(plans.get(i))).automated(true)).name("Signal " + i);
                    firstSegmentSignal = false;
                    tasks.add(tp);
                    arrayList.add(tp);
                } else {
                    tp = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(Task.TaskType.WaitTask)).checkpointPlan(plans.get(i))).automated(true)).name("Wait " + i);
                    firstSegmentSignal = true;
                    tasks.add(tp);
                    arrayList.add(tp);
                }
                tasksToSegment.put(seg, arrayList);
            }
            new TaskPlan().post(tasks);
            new SegmentPlan().post(segments);
            for (SegmentPlan segmentPlan : segments) {
                if (previousSeg != null) {
                    segmentPlan.prerequisites(previousSeg).save();
                }
                previousSeg = segmentPlan;
            }
            for (Map.Entry entry : tasksToSegment.entrySet()) {
                for (TaskPlan task : (List)entry.getValue()) {
                    ((SegmentPlan)entry.getKey()).addTask(task);
                }
            }
            return sd;
        }

        @Deprecated
        public ScheduledDeployment provisionSuperDeployment() {
            ScheduledDeployment sd = this.provisionSimpleDeploymentWithVersion("Release for Super SD " + System.currentTimeMillis(), ReleaseEnvironment.DEV_1, "App for Super SD " + System.currentTimeMillis(), "1.0");
            ((ApprovalTemplate)InternalClients.approvalTemplate().phaseId(((Release)sd.getRelease().get()).getPhases()[0].getId()).executorRoleId(Role.ADMIN.id).name("Approval for Super Deployment" + System.currentTimeMillis())).save();
            DeploymentPlan plan2 = DeploymentPlan.createSimpleDeploymentPlan("DeploymentPlan_" + System.currentTimeMillis(), ((ScheduledDeployment)sd.get()).release, 3, 3);
            TaskTag tag = (TaskTag)((TaskTag)InternalClients.taskTag().name("Tag for Super SD " + System.currentTimeMillis())).color("#000000").save();
            TaskPlan taskPlan1 = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().name("Adding task with a Role to Plan")).taskPattern(Task.ExecutionPattern.ALWAYS)).executorRoleOrGroup(Role.ADMIN)).updateVersion(false)).save();
            DeploymentPlan plan = (DeploymentPlan)((Phase)((Release)sd.getRelease().get()).phases[0].get()).deploymentPlan.get();
            ((DeploymentPlan)((DeploymentExecution)sd.getDeploymentExecution().get()).deploymentPlan.get()).segments[0].addTask(taskPlan1);
            return sd;
        }

        public ScheduledDeployment addTaskExecutionToScheduledDeployment(ScheduledDeployment sd, String taskName, Task.TaskType taskType, boolean automated, int segmentIndex) {
            return this.addTaskExecutionWithCheckpointToScheduledDeployment(sd, taskName, taskType, null, automated, segmentIndex);
        }

        public ScheduledDeployment addTaskExecutionWithCheckpointToScheduledDeployment(ScheduledDeployment sd, String taskName, Task.TaskType taskType, CheckpointPlan checkpointPlan, boolean automated, int segmentIndex) {
            TaskExecution te = ((TaskExecution)((TaskExecution)((TaskExecution)((TaskExecution)InternalClients.taskExecution().taskType(taskType)).checkpointPlan(checkpointPlan)).automated(automated)).name(taskName)).save();
            return this.addTaskExecutionToScheduledDeployment(sd, te, segmentIndex);
        }

        public ScheduledDeployment addTaskExecutionToScheduledDeployment(ScheduledDeployment sd, TaskExecution te, int segmentIndex) {
            sd = (ScheduledDeployment)sd.get();
            sd.deploymentExecution.segments[segmentIndex].addTask(te);
            return sd;
        }

        public ScheduledDeployment addTaskExecutionWithCheckpointToScheduledDeploymentViaTaskPlan(ScheduledDeployment sd, String taskName, Task.TaskType taskType, CheckpointPlan checkpointPlan, boolean automated, int segmentIndex) {
            TaskPlan tp = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().taskType(taskType)).checkpointPlan(checkpointPlan)).automated(automated)).name(taskName)).save();
            return this.addTaskExecutionToScheduledDeploymentViaTaskPlan(sd, tp, segmentIndex);
        }

        public ScheduledDeployment addTaskExecutionToScheduledDeploymentViaTaskPlan(ScheduledDeployment sd, String taskName, Task.TaskType taskType, boolean automated, int segmentIndex) {
            return this.addTaskExecutionWithCheckpointToScheduledDeploymentViaTaskPlan(sd, taskName, taskType, null, automated, segmentIndex);
        }

        public ScheduledDeployment addTaskExecutionToScheduledDeploymentViaTaskPlan(ScheduledDeployment sd, TaskPlan tp, int segmentIndex) {
            DeploymentPlan dp = (DeploymentPlan)sd.deploymentExecution.deploymentPlan.get();
            dp.segments[segmentIndex].addTask(tp);
            return (ScheduledDeployment)sd.get();
        }

        static {
            HashMap<String, String[]> tempMap = new HashMap<String, String[]>();
            tempMap.put("Release Manager", new String[]{"Chad Smith", "Vanessa Mills"});
            tempMap.put("DB Admin", new String[]{"James Henderickson", "Lily Langdon"});
            tempMap.put("Operations", new String[]{"Lauren Gill", "Pete Francis"});
            tempMap.put("Executive", new String[]{"Florence Wells", "Adrian Gray"});
            tempMap.put("QA Manager", new String[]{"Nicola Morgan", "Adam Watson"});
            rolesToUsers = Collections.unmodifiableMap(tempMap);
            taskNames = new String[][][]{{{"Send Preliminary Outage Notice", "Release Manager"}, {"Confirm Go/No-Go", "Executive"}, {"Update summary and highlight alterations", "Release Manager"}, {"Verify UCD Snapshot contents", "QA Manager"}, {"Verify Target Hosts Are Ready", "Operations"}, {"Verify All QA Sign-offs", "QA Manager"}, {"Send out deployment roster", "Release Manager"}, {"Update DataTrack Pro with CCW status", "Release Manager"}, {"Complete all at-large PDDs", "Release Manager"}, {"Alert Exec team of readiness", "Release Manager"}, {"Confirm Business Partner Readiness", "Release Manager"}, {"Prepare Binaries", "Operations"}, {"Prepare DB scripts and alert team", "DB Admin"}, {"Signal RMO Alert", "Release Manager"}}, {{"Configure Outage Notice", "Operations"}, {"Prep re-route", "Operations"}, {"Prep DNS configuration", "Operations"}, {"Publish DNS updates", "Operations"}, {"Alert Datacenter Admin", "Operations"}, {"Shutdown AQY Proxy", "Operations"}, {"Disable CQ Monitoring", "Operations"}, {"Confirm Splash Page - Alert 22C", "Release Manager"}, {"Halt Enabler Process", "Operations"}, {"Disable Load Balancer DOS_IP", "Operations"}, {"Switch RFM Logger to Standby", "QA Manager"}, {"Halt Traffic Reporting", "QA Manager"}, {"VA - Reset CDN hit counter", "Operations"}, {"VA - Prep CDN content", "Operations"}, {"VA - Restart MMV Edge Server"}}, {{"Configure Outage Notice", "Operations"}, {"Prep re-route", "Operations"}, {"Prep DNS configuration", "Operations"}, {"Publish DNS updates", "Operations"}, {"Alert Datacenter Admin", "Operations"}, {"Shutdown AQY Proxy", "Operations"}, {"Disable CQ Monitoring", "Operations"}, {"Confirm Splash Page - Alert 22C", "Operations"}, {"Halt Enabler Process", "Operations"}, {"Disable Load Balancer DOS_IP", "Operations"}, {"Switch RFM Logger to Standby", "QA Manager"}, {"Halt Traffic Reporting", "QA Manager"}, {"TX - Reset CDN hit counter", "Operations"}, {"TX - Prep CDN content", "Operations"}, {"TX - Restart MMV Edge Server", "Operations"}}, {{"Shutdown RN App", "Operations"}, {"Shutdown RN Job", "Operations"}, {"Shutdown Enterprise NNC System", "Operations"}, {"Disable NNC Datafeed", "DB Admin"}, {"Shutdown DB2 ABQ Instance", "DB Admin"}, {"Shutdown DB2 ANS Instance", "DB Admin"}, {"Recycle INT Power", "Operations"}, {"Shutdown CBB", "Operations"}, {"Run shutdown_xTBB.sh on Master Host", "Operations"}, {"Recycle Slave Systems", "Operations"}, {"Shut off Distribution N Dataspool", "Operations"}, {"Shutdown SVCS", "Operations"}, {"Stop DB2 Replication Service", "DB Admin"}, {"Set eBusiness App on StandBy", "Operations"}, {"Kill Quartz Job Runner", "Operations"}}, {{"Restart DB2 Master service", "DB Admin"}, {"Restart DB2 Replication", "DB Admin"}, {"Prepare index.DDL", "DB Admin"}, {"Prepare quartz-foreign-key.ddl", "DB Admin"}, {"Execute ucc-seed-data.sql", "DB Admin"}, {"Run SETS app db update script", "DB Admin"}, {"Update DB_Version entry", "DB Admin"}, {"Evaluate ZDT Differential", "QA Manager"}, {"Execute DB_Batch_TX", "DB Admin"}, {"Execute DB_Batch_VA", "DB Admin"}, {"Execute DB_Batch_EU", "DB Admin"}, {"Verify Schema Correctness", "DB Admin"}, {"DBA Sign-off", "DB Admin"}, {"DBA Audit Entry", "DB Admin"}, {"DBA Alert", "DB Admin"}}, {{"Deploy AGG EAR", "Operations"}, {"Deploy Static Content", "Operations"}, {"Deploy PILOT Service EAR", "Operations"}, {"Deploy AuthService Update", "Operations"}, {"Deploy NEA EAR", "Operations"}, {"Deploy NEA Static", "Operations"}, {"Update CDN Content - VA", "Operations"}, {"Update CDN Content - TX", "Operations"}, {"Update CDN Content - EU", "Operations"}, {"Deploy MG with Cleared Cache", "Operations"}, {"Recycle AGG Cached Regristry", "Operations"}, {"Deploy Batched eBilling Script", "Operations"}, {"Deploy Batched Image", "Operations"}, {"Update IVP Runner", "Operations"}, {"Deploy new Quartz Job Definitions", "Operations"}}, {{"Trigger Datacenter Startup Proc - VA", "Operations"}, {"Trigger Datacenter Startup Proc - TX", "Operations"}, {"Trigger Datacenter Startup Proc - EU", "Operations"}, {"Startup AGG Cache", "Operations"}, {"Startup CBB Service", "Operations"}, {"Start RN App", "Operations"}, {"Start RN Job", "Operations"}, {"Startup Enterprise NNC System", "Operations"}, {"Enable NNC Datafeed", "Operations"}, {"Start DB2 ABQ Instance", "DB Admin"}, {"Start DB2 ANS Instance", "DB Admin"}, {"Start Quartz Job Runner", "DB Admin"}, {"Run startup_xTBB.sh on Master Host", "Operations"}, {"Start DB2 Replication Service", "DB Admin"}, {"Set eBusiness App to Active", "Operations"}}, {{"Trigger Datacenter Startup Proc - VA", "Operations"}, {"Trigger Datacenter Startup Proc - TX", "Operations"}, {"Trigger Datacenter Startup Proc - EU", "Operations"}, {"Startup AGG Cache", "Operations"}, {"Startup CBB Service", "Operations"}, {"Start RN App", "Operations"}, {"Start RN Job", "Operations"}, {"Startup Enterprise NNC System", "Operations"}, {"Enable NNC Datafeed", "DB Admin"}, {"Start DB2 ABQ Instance", "DB Admin"}, {"Start DB2 ANS Instance", "DB Admin"}, {"Start Quartz Job Runner", "Operations"}, {"Run startup_xTBB.sh on Master Host", "Operations"}, {"Start DB2 Replication Service", "DB Admin"}, {"Set eBusiness App to Active", "Operations"}}, {{"Enable Monitoring - Verify Response", "Operations"}, {"Startup AQY Proxy - Verify Routing", "Operations"}, {"Enable Traffic Reporting", "Operations"}, {"Verify eBilling Service", "QA Manager"}, {"Verify eBusiness App -TX", "QA Manager"}, {"Verify eBusiness App -VA", "QA Manager"}, {"Publish Stability Analysis", "Release Manager"}, {"Run PILOT System acceptance tests", "QA Manager"}, {"Alert Management of post deployment CritSit Findings", "Release Manager"}}};
        }
    }

    public static class InnerUpdate {
        public Long lastRefresh;
        public String name;
        public Long startTimePlanned;
        public Long startTimeEstimated;
        public Long startTimeActual;
        public Long endTimePlanned;
        public Long endTimeEstimated;
        public Long endTimeActual;
        public Long durationPlanned;
        public Long durationRemaining;
        public String status;
        public String result;
        public Boolean belongsToCurrentUser;
        public Boolean isReady;
        public String userId;
        public String userName;
    }

    public static class UpdateFormat {
        public Boolean refresh;
        public Map<String, InnerUpdate> update;

        public InnerUpdate getUpdateFor(ClientEntity<?> fullEntity) {
            return this.update.get(fullEntity.id);
        }

        public boolean matches(TaskExecution task) {
            InnerUpdate patch = this.getUpdateFor(task);
            return Objects.equal(task.status, patch.status) && Objects.equal(task.result, patch.result);
        }

        public boolean matches(SegmentExecution segment) {
            InnerUpdate patch = this.getUpdateFor(segment);
            boolean match = Objects.equal(segment.status, patch.status);
            if (!match) {
                return false;
            }
            for (TaskExecution task : segment.tasks) {
                if (this.matches(task)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(DeploymentExecution deployment) {
            InnerUpdate patch = this.getUpdateFor(deployment);
            boolean match = Objects.equal(deployment.status, patch.status);
            if (!match) {
                return false;
            }
            for (SegmentExecution segment : deployment.segments) {
                if (this.matches(segment)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(ScheduledDeployment sd) {
            return this.matches(sd.deploymentExecution);
        }
    }

    public static enum StatusState {
        RED,
        YELLOW,
        GREEN;

    }

    public static enum CacheFormats {
        StructureFormat("detailFormat"),
        StatusFormat("updateFormat");

        public final String name;

        private CacheFormats(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

