/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.annotations.SerializedName;
import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.CheckpointPlan;
import com.urbancode.release.rest.models.internal.EnvironmentTag;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.SuggestedTask;
import com.urbancode.release.rest.models.internal.TaskComment;
import com.urbancode.release.rest.models.internal.TaskTag;

public abstract class Task<T extends Task>
extends ClientIntegrated<T> {
    public Boolean automated;
    public Boolean updateVersion;
    public Boolean active;
    public Boolean onlyChangedVersions;
    public Application application;
    public Role executorRole;
    public Group executorGroup;
    public User user;
    public Long duration;
    public ExecutionPattern taskPattern;
    public boolean requireApplicationVersion = true;
    public String executionStep;
    public TagMatch targetMatch;
    public TagMatch tagOption;
    public String[] environments;
    public String[] tags;
    public String[] tagIds;
    public TaskTag[] taskTags;
    @SerializedName(value="taskTypeModuleClassName")
    public TaskType taskType;
    public CheckpointPlan checkpointPlan;
    @JsonReadOnly
    public String[] prerequisiteIds = new String[0];
    @JsonReadOnly
    public Boolean userCanExecute;
    @JsonReadOnly
    public Boolean belongsToCurrentUser;
    @JsonReadOnly
    public String userName;
    public String userId;
    @JsonReadOnly
    public String[] completeEnvironments;
    @JsonReadOnly
    public TaskComment[] comments;
    @JsonReadOnly
    public SuggestedTask[] suggestionsReferencingThis;
    @JsonReadOnly
    public Integer taskOrderPos;

    public T setAutomated(boolean automated) {
        return this.automated(automated);
    }

    public T automated(boolean automated) {
        this.automated = automated;
        return (T)this;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public String getExecutionStep() {
        return this.executionStep;
    }

    public T active(boolean active) {
        this.active = active;
        return (T)this;
    }

    public T executionStep(String executionStep) {
        this.executionStep = executionStep;
        return (T)this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public boolean requireApplicationVersion() {
        return this.requireApplicationVersion;
    }

    public T requireApplicationVersion(boolean requireApplicationVersion) {
        this.requireApplicationVersion = requireApplicationVersion;
        return (T)this;
    }

    public T taskType(TaskType taskType) {
        this.taskType = taskType;
        return (T)this;
    }

    public T checkpointPlan(CheckpointPlan checkpointPlan) {
        this.checkpointPlan = checkpointPlan;
        return (T)this;
    }

    public Task setActive(boolean active) {
        return this.active(active);
    }

    public T onlyChangedVersions(boolean onlyChangedVersions) {
        this.onlyChangedVersions = onlyChangedVersions;
        return (T)this;
    }

    public T updateVersion(boolean updateVersion) {
        this.updateVersion = updateVersion;
        return (T)this;
    }

    public T application(Application application) {
        this.handleNull(application, "application");
        this.application = application;
        return (T)this;
    }

    public T applicationVersionRequired(boolean applicationVersionrequired) {
        this.handleNull(this.application, "application");
        this.requireApplicationVersion = applicationVersionrequired;
        return (T)this;
    }

    public T setApplication(Application application) {
        return this.application(application);
    }

    public T executorRoleOrGroup(Role executorRole) {
        this.handleNull(executorRole, "executorRole");
        this.executorRole = executorRole;
        this.handleNull(null, "executorGroup");
        this.executorGroup = null;
        return (T)this;
    }

    public T executorRoleOrGroup(Group executorGroup) {
        this.handleNull(executorGroup, "executorGroup");
        this.executorGroup = executorGroup;
        this.handleNull(null, "executorRole");
        this.executorRole = null;
        return (T)this;
    }

    public T user(User user) {
        this.handleNull(user, "user", "userId");
        this.user = user;
        this.userId = user.id;
        return (T)this;
    }

    public T duration(Long duration) {
        this.duration = duration;
        return (T)this;
    }

    public T taskPattern(ExecutionPattern taskPattern) {
        this.taskPattern = taskPattern;
        return (T)this;
    }

    public T targetMatch(TagMatch targetMatch) {
        this.targetMatch = targetMatch;
        this.tagOption = targetMatch;
        return (T)this;
    }

    public T environments(ReleaseEnvironment ... environments) {
        this.handleNull(environments, "environments");
        this.environments = Task.ids(environments);
        return (T)this;
    }

    public T tags(EnvironmentTag ... tags) {
        if (this.handleNull(tags, "tags", "tagIds")) {
            this.tags = Task.ids(tags);
            this.tagIds = Task.ids(tags);
        } else {
            this.tags = null;
            this.tagIds = null;
        }
        return (T)this;
    }

    public T taskTags(TaskTag ... taskTags) {
        this.handleNull(taskTags, "taskTags");
        this.taskTags = taskTags;
        return (T)this;
    }

    public static enum TaskType {
        WaitTask,
        SignalTask,
        UCDTask,
        ManualTask,
        NotificationTask,
        PluginTask;

    }

    public static enum TagMatch {
        ALL_TARGETS,
        WITH_ALL_OF_TAGS,
        WITH_ANY_OF_TAGS;

    }

    public static enum ExecutionPattern {
        ALWAYS,
        ONCE_PER_ENVIRONMENT;

    }
}

