/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.iterator.files;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.iterator.AbstractSentinelIterator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
final class EachFileAndDirectoryRecursiveIterator
extends AbstractSentinelIterator<File> {
    private final List<File> directoryStack = new ArrayList<File>();
    private Iterator<File> currentDirectory;

    EachFileAndDirectoryRecursiveIterator(File directory) {
        this.currentDirectory = IO.listFiles(directory).iterator();
    }

    @Override
    protected File nextItem() {
        File result = null;
        boolean done = false;
        while (!done) {
            if (!this.currentDirectory.hasNext()) {
                if (!this.directoryStack.isEmpty()) {
                    File directory = this.directoryStack.remove(this.directoryStack.size() - 1);
                    this.currentDirectory = IO.listFiles(directory).iterator();
                } else {
                    this.currentDirectory = Collections.emptyList().iterator();
                    done = true;
                }
            }
            while (!done && this.currentDirectory.hasNext()) {
                File file = this.currentDirectory.next();
                if (file.isFile()) {
                    result = file;
                    done = true;
                    continue;
                }
                if (file.isDirectory()) {
                    this.directoryStack.add(file);
                    result = file;
                    done = true;
                    continue;
                }
                result = file;
                done = true;
            }
        }
        return result;
    }
}

