/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientNamed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.Command;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class Plugin
extends ClientNamed<Plugin> {
    public static final String PLUGIN_DIR_PATH = "ucr.plugin.dir";
    @JsonReadOnly
    public long pluginVersion;
    @JsonReadOnly
    public Command[] commands;

    public Plugin() {
        this.path = "/plugins/";
    }

    public long getPluginVersion() {
        return this.pluginVersion;
    }

    public Plugin setPluginVersion(long version) {
        return this.pluginVersion(version);
    }

    public Plugin pluginVersion(long version) {
        this.pluginVersion = version;
        return this;
    }

    public Command[] getCommands() {
        return this.commands;
    }

    public Plugin setCommands(Command[] commands) {
        return this.commands(commands);
    }

    public Plugin commands(Command[] commands) {
        this.commands = commands;
        return this;
    }

    public Plugin getLatestVersionByName(String name) {
        return ((Response)RestAssured.given().get("plugins/latestVersionByName/" + name, new Object[0])).as(Plugin.class, ObjectMapperType.GSON);
    }

    public void uploadPlugin(String fileName) throws FileNotFoundException {
        File[] listOfFiles;
        if (System.getProperty(PLUGIN_DIR_PATH) == null || System.getProperty(PLUGIN_DIR_PATH).isEmpty()) {
            throw new IllegalArgumentException("ucr.plugin.dir has not been set");
        }
        String pluginFileNameFound = null;
        String dir = System.getProperty(PLUGIN_DIR_PATH);
        if (!dir.endsWith("/")) {
            dir = dir + "/";
        }
        for (File file : listOfFiles = new File(dir).listFiles()) {
            if (!file.getName().startsWith(fileName) || !file.getName().endsWith(".zip")) continue;
            pluginFileNameFound = file.getName();
            break;
        }
        if (pluginFileNameFound == null) {
            throw new FileNotFoundException("No zip files with prefix " + fileName + " could be found!");
        }
        FileInputStream is = new FileInputStream(dir + pluginFileNameFound);
        RestAssured.given().multiPart("file", new File(dir + pluginFileNameFound)).multiPart("file", fileName, is).contentType("multipart/form-data").expect().statusCode(200).when().post("/plugins/import", new Object[0]);
    }
}

