/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.unix;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Bits;
import java.util.ArrayList;
import java.util.Iterator;

@BridgeMethodsAdded
public class SymbolicMode {
    final int mode;
    final int mask;

    public static SymbolicMode createFromNumeric(int mode, int mask) {
        return new SymbolicMode(mode, mask);
    }

    private SymbolicMode(int mode, int mask) {
        if (mode < 0 || mode > 4095) {
            throw new IllegalArgumentException(String.format("Invalid mode %04o", mode));
        }
        if (mask < 0 || mask > 4095) {
            throw new IllegalArgumentException(String.format("Invalid mask %04o", mask));
        }
        this.mode = mode;
        this.mask = mask;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>();
        if (this.isSetMask(2048)) {
            parts.add("u" + (this.isSetMode(2048) ? "+" : "-") + "s");
        }
        if (this.isSetMask(1024)) {
            parts.add("g" + (this.isSetMode(1024) ? "+" : "-") + "s");
        }
        if (this.isSetMask(512)) {
            parts.add((this.isSetMode(512) ? "+" : "-") + "t");
        }
        if (this.isSetMask(256)) {
            parts.add("u" + (this.isSetMode(256) ? "+" : "-") + "r");
        }
        if (this.isSetMask(128)) {
            parts.add("u" + (this.isSetMode(128) ? "+" : "-") + "w");
        }
        if (this.isSetMask(64)) {
            parts.add("u" + (this.isSetMode(64) ? "+" : "-") + "x");
        }
        if (this.isSetMask(32)) {
            parts.add("g" + (this.isSetMode(32) ? "+" : "-") + "r");
        }
        if (this.isSetMask(16)) {
            parts.add("g" + (this.isSetMode(16) ? "+" : "-") + "w");
        }
        if (this.isSetMask(8)) {
            parts.add("g" + (this.isSetMode(8) ? "+" : "-") + "x");
        }
        if (this.isSetMask(4)) {
            parts.add("o" + (this.isSetMode(4) ? "+" : "-") + "r");
        }
        if (this.isSetMask(2)) {
            parts.add("o" + (this.isSetMode(2) ? "+" : "-") + "w");
        }
        if (this.isSetMask(1)) {
            parts.add("o" + (this.isSetMode(1) ? "+" : "-") + "x");
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = parts.iterator();
        if (i.hasNext()) {
            sb.append((String)i.next());
        }
        while (i.hasNext()) {
            sb.append(',');
            sb.append((String)i.next());
        }
        return sb.toString();
    }

    private int getMode() {
        return this.mode;
    }

    private int getMask() {
        return this.mask;
    }

    private boolean isSetMask(int bit) {
        return Bits.isSet(this.getMask(), bit);
    }

    private boolean isSetMode(int bit) {
        return Bits.isSet(this.getMode(), bit);
    }
}

