/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.clock.CurrentTimeMillisClock;
import com.urbancode.commons.util.dbprofiler.DbProfile;
import com.urbancode.commons.util.dbprofiler.NoOpDbProfileCounter;
import com.urbancode.commons.util.dbprofiler.RealDbProfileCounter;

@BridgeMethodsAdded
abstract class DbProfileCounter {
    private static final ThreadLocal<Boolean> profiling = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    private static final ThreadLocal<DbProfileCounter> profileCounter = new ThreadLocal<DbProfileCounter>(){

        @Override
        protected DbProfileCounter initialValue() {
            return new NoOpDbProfileCounter();
        }
    };

    DbProfileCounter() {
    }

    static void startProfiling() {
        if (profiling.get().booleanValue()) {
            throw new IllegalStateException("Already profiling");
        }
        profiling.set(true);
        profileCounter.set(new RealDbProfileCounter(new CurrentTimeMillisClock()));
    }

    static DbProfile stopProfiling() {
        if (!profiling.get().booleanValue()) {
            throw new IllegalStateException("Not profiling");
        }
        profiling.set(false);
        DbProfileCounter counter = profileCounter.get();
        profileCounter.remove();
        return counter.getProfile();
    }

    static DbProfileCounter getCounter() {
        return profileCounter.get();
    }

    public abstract DbProfile getProfile();

    public abstract void startExecute();

    public abstract void endExecute();

    public abstract void startCommit();

    public abstract void endCommit();

    public abstract void startRollback();

    public abstract void endRollback();
}

