/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.models.BuiltInAuthorizationRealm;
import com.urbancode.release.rest.models.LdapAuthorizationRealm;
import java.lang.reflect.Type;

public class AuthorizationRealm<T extends AuthorizationRealm>
extends ClientDescribed<T> {
    public static final BuiltInAuthorizationRealm BUILTIN = (BuiltInAuthorizationRealm)new BuiltInAuthorizationRealm().id("00000000-0000-0000-0000-000000000000");
    protected String authorizationModuleClassName;

    public AuthorizationRealm() {
        this.path = "/authorizationRealms/";
        this.authorizationModuleClassName = null;
    }

    public String getAuthorizationModuleClassName() {
        return this.authorizationModuleClassName;
    }

    public static class Deserializer
    implements JsonDeserializer<AuthorizationRealm> {
        @Override
        public AuthorizationRealm deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonNull()) {
                return null;
            }
            if (json.isJsonPrimitive()) {
                return (AuthorizationRealm)new AuthorizationRealm().id(json.getAsString());
            }
            if (json.isJsonObject()) {
                JsonObject jo = json.getAsJsonObject();
                if (jo.has("authorizationModuleClassName")) {
                    AuthorizationRealmType arType = (AuthorizationRealmType)((Object)context.deserialize(jo.get("authorizationModuleClassName"), (Type)((Object)AuthorizationRealmType.class)));
                    return (AuthorizationRealm)context.deserialize(jo, arType.clientClass);
                }
                if (jo.has("id")) {
                    return (AuthorizationRealm)new AuthorizationRealm().id(jo.get("id").getAsString());
                }
                throw new IllegalStateException("AuthorizationRealm references must have at least an 'id' property");
            }
            throw new IllegalStateException("AuthorizationRealm references should not receive a JsonArray");
        }
    }

    public static enum AuthorizationRealmType {
        BUILTIN(BuiltInAuthorizationRealm.class),
        LDAP(LdapAuthorizationRealm.class);

        public Class<? extends AuthorizationRealm> clientClass;

        private AuthorizationRealmType(Class<? extends AuthorizationRealm> clientClass) {
            this.clientClass = clientClass;
        }

        public String getTypeString() {
            return ((Object)((Object)this)).getClass().getAnnotation(SerializedName.class).value();
        }

        public AuthorizationRealmType fromTypeString(String typeString) {
            for (AuthorizationRealmType type : AuthorizationRealmType.values()) {
                if (!type.getTypeString().equals(typeString)) continue;
                return type;
            }
            return null;
        }
    }
}

