/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Event;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.internal.EventType;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.TaskTag;

public class RelatedDeployment
extends ClientEntity<RelatedDeployment> {
    public ScheduledDeployment[] scheduledDeployments;
    @JsonReadOnly
    public TaskTag[] taskTags;
    @JsonReadOnly
    public User creator;
    @JsonReadOnly
    public Event event;

    public RelatedDeployment() {
        this.path = "/relatedDeployments/";
    }

    public User getCreator() {
        return this.creator;
    }

    public Event getEvent() {
        return this.event;
    }

    public RelatedDeployment creator(User user) {
        this.creator = user;
        return this;
    }

    public ScheduledDeployment[] getScheduledDeployments() {
        return this.scheduledDeployments;
    }

    public RelatedDeployment setScheduledDeployments(ScheduledDeployment[] scheduledDeployments) {
        return this.scheduledDeployments(scheduledDeployments);
    }

    public void addScheduledDeployments(ScheduledDeployment ... sds) {
        JsonArray ids = new JsonArray();
        for (ScheduledDeployment sd : sds) {
            ids.add(new JsonPrimitive(sd.getId()));
        }
        String json = ids.toString();
        RestAssured.given().body(json).post(this.path(this.id) + "/scheduledDeployments", new Object[0]);
    }

    public void removeScheduledDeployment(ScheduledDeployment sd) {
        JsonArray ids = new JsonArray();
        String json = ids.toString();
        RestAssured.given().body(json).delete(this.path(this.id) + "/scheduledDeployment/" + sd.getId(), new Object[0]);
    }

    public RelatedDeployment scheduledDeployments(ScheduledDeployment ... scheduledDeployments) {
        this.handleNull(scheduledDeployments, "scheduledDeployments");
        this.scheduledDeployments = scheduledDeployments;
        return this;
    }

    public TaskTag[] getTaskTags() {
        return this.taskTags;
    }

    public RelatedDeploymentTimeRemaining getTimeRemaining() {
        return ((Response)RestAssured.given().get(this.path(this.id) + "/timeRemaining", new Object[0])).as(RelatedDeploymentTimeRemaining.class, ObjectMapperType.GSON);
    }

    public RelatedDeployment createForEvent(Event event) {
        JsonObject eventToTurn = new JsonObject();
        eventToTurn.addProperty("event", event.id);
        return ((Response)RestAssured.given().body(eventToTurn.toString()).post(this.path() + "createForEvent", new Object[0])).as(RelatedDeployment.class, ObjectMapperType.GSON);
    }

    public static RelatedDeploymentDataGenerator getDataGenerator() {
        return new RelatedDeploymentDataGenerator();
    }

    public class RelatedDeploymentTimeRemaining {
        public int completedCount;
        public Long endTimeOverride;
        public Long endTimePlanned;
        public Long estimatedEndTime;
        public Long estimatedStartTime;
        public int failedCount;
        public int notStartedCount;
        public int startedCount;
        public int totalCount;
    }

    public static class RelatedDeploymentDataGenerator
    extends ClientEntity.DataGenerator<RelatedDeployment> {
        public RelatedDeployment createRelatedDeployment(String eventTypeName, String eventName) {
            Long oneMonth = 2764800000L;
            EventType type = (EventType)((EventType)InternalClients.eventType().name(eventTypeName)).eventTypeModule("RelatedDeploymentModule").save();
            Event event = (Event)((Event)new Event().name(eventName)).type(type).setStartDate(System.currentTimeMillis()).endDate(System.currentTimeMillis() + oneMonth).save();
            event = (Event)event.get();
            RelatedDeployment result = event.getRelatedDeployment();
            return (RelatedDeployment)result.get();
        }
    }
}

