/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2015. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.automation.UCRClient


def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

UCRClient ucrClient = new UCRClient(props)

try {
    ucrClient.init()

    println("Deleting all existing HP ALM changes on the UCR server.")
    ucrClient.deleteAllChanges()
}
catch (Exception ex) {
    println("Error while deleting HP ALM changes.")
    ex.printStackTrace()
    System.exit(1)
}

System.exit(0)