/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.framework;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.builder.RequestSpecBuilder;
import com.jayway.restassured.config.HttpClientConfig;
import com.jayway.restassured.config.ObjectMapperConfig;
import com.jayway.restassured.config.RestAssuredConfig;
import com.jayway.restassured.config.SSLConfig;
import com.jayway.restassured.filter.log.LogDetail;
import com.jayway.restassured.filter.log.ResponseLoggingFilter;
import com.jayway.restassured.filter.session.SessionFilter;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.mapper.factory.GsonObjectMapperFactory;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.urbancode.release.rest.framework.internal.ExplicitNullsDereferencingFactory;
import com.urbancode.release.rest.framework.internal.SuppressReadOnlyStrategy;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.AuthenticationRealm;
import com.urbancode.release.rest.models.AuthorizationRealm;
import com.urbancode.release.rest.models.Change;
import com.urbancode.release.rest.models.ChangeType;
import com.urbancode.release.rest.models.Component;
import com.urbancode.release.rest.models.EnvironmentReservation;
import com.urbancode.release.rest.models.Event;
import com.urbancode.release.rest.models.Group;
import com.urbancode.release.rest.models.Initiative;
import com.urbancode.release.rest.models.LdapAuthenticationRealm;
import com.urbancode.release.rest.models.LdapAuthorizationRealm;
import com.urbancode.release.rest.models.NotificationRule;
import com.urbancode.release.rest.models.NotificationScheme;
import com.urbancode.release.rest.models.NotificationTemplate;
import com.urbancode.release.rest.models.RecurringDeployment;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.Version;
import com.urbancode.release.rest.models.internal.CheckpointPlan;
import com.urbancode.release.rest.models.internal.FederatedDeployment;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import com.urbancode.release.rest.models.internal.RelatedDeployment;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.hamcrest.Matchers;

public class Clients {
    protected static Logger log = Logger.getLogger(Clients.class);
    private static int defaultTimeout = 0;

    public static void loginWithToken(String baseURL, String token) {
        try {
            JSONObject tokenJson = new JSONObject(token);
            if (!tokenJson.has("token")) {
                throw new RuntimeException("The Token Json should contain a token attribute");
            }
        }
        catch (JSONException ex) {
            JSONObject tokenObject = new JSONObject();
            try {
                tokenObject.put("token", (Object)token);
                token = tokenObject.toString();
            }
            catch (JSONException e) {
                throw new RuntimeException("The Token could not be turned into a JSON Object");
            }
        }
        Clients.loginAs(baseURL, "PasswordIsAuthToken", token);
    }

    public static void loginWithToken(String baseURL, String token, int timeout) {
        defaultTimeout = timeout;
        Clients.loginWithToken(baseURL, token);
    }

    public static void loginAs(String baseURL, String username, String password, int timeout) {
        defaultTimeout = timeout;
        Clients.loginAs(baseURL, username, password);
    }

    public static void loginAs(String baseURL, String username, String password) {
        Clients.printVersionNumber();
        RestAssured.config = RestAssuredConfig.config().objectMapperConfig(ObjectMapperConfig.objectMapperConfig().gsonObjectMapperFactory(new GsonObjectMapperFactory(){

            @Override
            public Gson create(Class cls, String charset) {
                GsonBuilder gson = new GsonBuilder().serializeNulls().registerTypeAdapterFactory(new ExplicitNullsDereferencingFactory()).addSerializationExclusionStrategy(new SuppressReadOnlyStrategy()).registerTypeAdapter((Type)((Object)IntegrationProvider.class), new IntegrationProvider.Deserializer()).registerTypeAdapter((Type)((Object)AuthenticationRealm.class), new AuthenticationRealm.Deserializer()).registerTypeAdapter((Type)((Object)AuthorizationRealm.class), new AuthorizationRealm.Deserializer());
                if (log.isDebugEnabled()) {
                    gson.setPrettyPrinting();
                }
                return gson.create();
            }
        }));
        RestAssured.requestSpecification = new RequestSpecBuilder().setPort(80).build();
        try {
            TrustStrategy acceptingTrustStrategy = new TrustStrategy(){

                @Override
                public boolean isTrusted(X509Certificate[] certificate, String authType) {
                    return true;
                }
            };
            SSLSocketFactory sslFactory = new SSLSocketFactory(acceptingTrustStrategy, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            RestAssuredConfig config = RestAssured.config().sslConfig(SSLConfig.sslConfig().sslSocketFactory(sslFactory));
            if (defaultTimeout != 0) {
                config.httpClient(HttpClientConfig.httpClientConfig().setParam("http.conn-manager.timeout", Long.valueOf(defaultTimeout)).setParam("http.connection.timeout", defaultTimeout).setParam("http.socket.timeout", defaultTimeout));
            }
            RestAssured.requestSpecification = RestAssured.given().config(config);
            URL serverUrl = new URL(baseURL);
            if (serverUrl.getProtocol().equals("https") && serverUrl.getPort() == -1) {
                RestAssured.requestSpecification = RestAssured.given().port(443);
            }
        }
        catch (Exception ex) {
            log.error("Can not apply SSL strategy " + ex);
        }
        RestAssured.requestSpecification = log.isDebugEnabled() ? ((RequestSpecification)RestAssured.given().log().all(false)).filter(new ResponseLoggingFilter(LogDetail.ALL, false, System.out)) : RestAssured.given().filter(new ResponseLoggingFilter(LogDetail.ALL, false, System.out, Matchers.greaterThanOrEqualTo(400)));
        RestAssured.requestSpecification = RestAssured.given().baseUri(baseURL).contentType(ContentType.JSON).auth().basic(username, password).filter(new SessionFilter());
        String sessionKey = ((Response)RestAssured.expect().contentType(ContentType.JSON).get("ping", new Object[0])).cookie("UCR_SESSION_KEY");
        log.debug("Retrieved initial UCR_SESSION_KEY:" + sessionKey);
        RestAssured.requestSpecification = RestAssured.given().cookie("UCR_SESSION_KEY", sessionKey, new Object[0]);
        RestAssured.requestSpecification = RestAssured.given().header("UCR_SESSION_KEY", sessionKey, new Object[0]);
        RestAssured.responseSpecification = RestAssured.expect().statusCode(200);
    }

    public static boolean urVersionGreaterThan(String versionString) {
        int i;
        Response response = (Response)RestAssured.expect().contentType(ContentType.JSON).get("ucrVersion", new Object[0]);
        String urVersion = response.getBody().asString().replace("[\"", "").replace("\"]", "");
        if (urVersion.equalsIgnoreCase("dev")) {
            return true;
        }
        String[] verNumsA = urVersion.split("\\.");
        String[] verNumsB = versionString.split("\\.");
        ArrayList<Integer> verIntsA = new ArrayList<Integer>();
        ArrayList<Integer> verIntsB = new ArrayList<Integer>();
        for (i = 0; i < verNumsA.length; ++i) {
            try {
                verIntsA.add(Integer.parseInt(verNumsA[i]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (i = 0; i < verNumsB.length; ++i) {
            try {
                verIntsB.add(Integer.parseInt(verNumsB[i]));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        for (i = 0; i < verIntsA.size(); ++i) {
            if (i >= verIntsB.size() || verIntsB.get(i) == null) {
                return true;
            }
            if ((Integer)verIntsB.get(i) <= (Integer)verIntsA.get(i)) continue;
            return false;
        }
        return true;
    }

    public static void printVersionNumber() {
        try {
            Enumeration<URL> resources = Clients.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                try {
                    Manifest manifest = new Manifest(resources.nextElement().openStream());
                    if (manifest.getMainAttributes() == null || manifest.getMainAttributes().getValue("Implementation-Version") == null || manifest.getMainAttributes().getValue("Implementation-Title") == null || !manifest.getMainAttributes().getValue("Implementation-Title").equals("urelease")) continue;
                    System.out.println("UCR Plugin Helper Version: " + manifest.getMainAttributes().getValue("Implementation-Version"));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    public static Application application() {
        return new Application();
    }

    public static Component component() {
        return new Component();
    }

    public static AuthenticationRealm<?> authenticationRealm() {
        return new AuthenticationRealm();
    }

    public static AuthorizationRealm<?> authorizationRealm() {
        return new AuthorizationRealm();
    }

    public static LdapAuthenticationRealm ldapAuthenticationRealm() {
        return new LdapAuthenticationRealm();
    }

    public static LdapAuthorizationRealm ldapAuthorizationRealm() {
        return new LdapAuthorizationRealm();
    }

    public static Change change() {
        return new Change();
    }

    public static ChangeType changeType() {
        return new ChangeType();
    }

    public static EnvironmentReservation environmentReservation() {
        return new EnvironmentReservation();
    }

    public static Event event() {
        return new Event();
    }

    public static FederatedDeployment federatedDeployment() {
        return new FederatedDeployment();
    }

    public static Group group() {
        return new Group();
    }

    public static Initiative initiative() {
        return new Initiative();
    }

    public static RelatedDeployment relatedDeployment() {
        return new RelatedDeployment();
    }

    public static RecurringDeployment recurringRule() {
        return new RecurringDeployment();
    }

    public static Release release() {
        return new Release();
    }

    public static Role role() {
        return new Role();
    }

    public static Team team() {
        return new Team();
    }

    public static User user() {
        return new User();
    }

    public static Version version() {
        return new Version();
    }

    public static CheckpointPlan checkpointPlan() {
        return new CheckpointPlan();
    }

    public static NotificationScheme notificationScheme() {
        return new NotificationScheme();
    }

    public static NotificationRule notificationRule() {
        return new NotificationRule();
    }

    public static NotificationTemplate notificationTemplate() {
        return new NotificationTemplate();
    }
}

