/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.JsonObject;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientNamed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.EnvironmentReservation;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.internal.ApprovalItem;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.PhaseModel;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;

public class Phase
extends ClientNamed<Phase> {
    public static final Phase DEV = (Phase)new Phase().id("00000000-0000-0000-0000-000000000021");
    public static final Phase CERT = (Phase)new Phase().id("00000000-0000-0000-0000-000000000022");
    public static final Phase QA = (Phase)new Phase().id("00000000-0000-0000-0000-000000000023");
    public static final Phase PT = (Phase)new Phase().id("00000000-0000-0000-0000-000000000024");
    public static final Phase PROD = (Phase)new Phase().id("00000000-0000-0000-0000-000000000025");
    public Long startDate;
    public Long endDate;
    public DeploymentPlan deploymentPlan;
    @JsonReadOnly
    public Boolean hasEdit;
    @JsonReadOnly
    public PhaseModel phaseModel;
    @JsonReadOnly
    public Release release;
    @JsonReadOnly
    public ReleaseEnvironment[] environments;
    @JsonReadOnly
    public ApprovalItem[] approvals;
    @JsonReadOnly
    public EnvironmentReservation[] reservations;
    @JsonReadOnly
    public ScheduledDeployment[] scheduledDeployments;

    public Phase() {
        this.path = "/phase/";
    }

    public Phase startDate(Long startDate) {
        this.startDate = startDate;
        return this;
    }

    public Phase endDate(Long endDate) {
        this.endDate = endDate;
        return this;
    }

    public Phase phaseModel(PhaseModel phaseModel) {
        this.handleNull(phaseModel, "phaseModel");
        this.phaseModel = phaseModel;
        return this;
    }

    public Phase release(Release release) {
        this.handleNull(release, "release");
        this.release = release;
        return this;
    }

    public Phase deploymentPlan(DeploymentPlan deploymentPlan) {
        this.handleNull(deploymentPlan, "deploymentPlan");
        this.deploymentPlan = deploymentPlan;
        return this;
    }

    @Deprecated
    public void addApprovalLegacy(String approvalName, Role role) {
        JsonObject body = new JsonObject();
        body.addProperty("phase", this.getId());
        body.addProperty("executorRole", role.getId());
        body.addProperty("executorRoleName", role.getName());
        body.addProperty("name", approvalName);
        ((Response)this.query.apply(RestAssured.given()).body(body.toString()).expect().statusCode(201).post("/phaseApproval/", new Object[0])).then();
    }

    @Deprecated
    public void removeApprovalLegacy(String approvalId) {
        JsonObject body = new JsonObject();
        ((Response)this.query.apply(RestAssured.given()).body(body.toString()).expect().statusCode(201).delete("/phaseApproval/" + approvalId, new Object[0])).then();
    }

    public Phase[] getAllFilterable() {
        log.debug("getAllWithPath()");
        return (Phase[])this.getAllWithPath("/lifecyclePhases/").as(this.arrayClass(), ObjectMapperType.GSON);
    }
}

