/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.Validate;

public class CustomErrorPageFilter
implements Filter {
    private String exceptionPage = null;

    public void init(FilterConfig config) throws ServletException {
        this.exceptionPage = config.getInitParameter("exceptionPage");
        Validate.notEmpty((String)this.exceptionPage, (String)"Exception Page can not be empty");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        try {
            filterChain.doFilter(request, response);
        }
        catch (RuntimeException e) {
            RuntimeException cause = e;
            request.setAttribute("exception", (Object)cause);
            request.getRequestDispatcher(this.exceptionPage).forward(request, response);
        }
        catch (ServletException e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            request.setAttribute("exception", (Object)cause);
            request.getRequestDispatcher(this.exceptionPage).forward(request, response);
        }
    }
}

