/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import com.urbancode.commons.util.query.QueryResult;
import com.urbancode.commons.webext.util.JSONCache;
import com.urbancode.commons.webext.util.JSONOutputType;
import com.urbancode.commons.webext.util.JSONUtilities;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResource<T>
extends JSONUtilities {
    public JSONArray toJSON(Collection<T> targets, JSONOutputType ... types) throws Exception {
        JSONArray result = new JSONArray();
        for (T target : targets) {
            result.put((Object)this.toJSON(target, types));
        }
        return result;
    }

    public JSONArray toJSON(T[] targets, JSONOutputType ... types) throws Exception {
        JSONArray result = new JSONArray();
        for (T target : targets) {
            result.put((Object)this.toJSON(target, types));
        }
        return result;
    }

    public JSONObject toJSON(T target, JSONOutputType ... types) throws Exception {
        JSONObject result = null;
        if (target != null) {
            result = new JSONObject();
            Set<JSONOutputType> typeSet = this.extractTypes(types);
            for (JSONOutputType type : typeSet) {
                switch (type) {
                    case BASIC: {
                        JSONObject basicJson = this.getBasicJSON(target);
                        result = JSONUtilities.mergeJsonObjects(result, basicJson);
                        break;
                    }
                    case LINKED: {
                        JSONObject linksJson = this.getLinkedJSON(target);
                        result = JSONUtilities.mergeJsonObjects(result, linksJson);
                        break;
                    }
                    case SECURITY: {
                        JSONObject securityJson = this.getSecurityJSON(target);
                        result = JSONUtilities.mergeJsonObjects(result, securityJson);
                        break;
                    }
                    case EXTENDED: {
                        JSONObject extendedJson = this.getExtendedJSON(target);
                        result = JSONUtilities.mergeJsonObjects(result, extendedJson);
                        break;
                    }
                    case EXPORT: {
                        result = this.getExportJSON(target);
                        break;
                    }
                }
            }
        }
        return result;
    }

    public Response toResponse(QueryResult<T> result, JSONOutputType ... types) throws Exception {
        return Response.status((int)200).entity((Object)this.toJSON(result.getResults(), types)).header("Content-Range", (Object)result.getContentRangeString()).build();
    }

    protected abstract JSONObject getBasicJSON(T var1) throws Exception;

    protected JSONObject getLinkedJSON(T target) throws Exception {
        return new JSONObject();
    }

    protected JSONObject getExtendedJSON(T target) throws Exception {
        return new JSONObject();
    }

    protected JSONObject getSecurityJSON(T target) throws Exception {
        return new JSONObject();
    }

    protected JSONObject getExportJSON(T target) throws Exception {
        return new JSONObject();
    }

    public T restore(Object targetId) {
        throw new UnsupportedOperationException("Cannot restore from " + this.getClass().getName() + " by ID.");
    }

    public JSONObject restoreToJSON(Object targetId, JSONOutputType ... types) throws Exception {
        Set<JSONOutputType> typeSet = this.extractTypes(types);
        HashSet<JSONOutputType> missingTypes = new HashSet<JSONOutputType>();
        JSONCache cache = JSONCache.getInstance();
        JSONObject result = null;
        if (targetId != null) {
            result = new JSONObject();
            for (JSONOutputType type : typeSet) {
                String cacheId = targetId.hashCode() + "#" + type.toString();
                JSONObject cachedObject = cache.get(cacheId);
                if (cachedObject == null) {
                    missingTypes.add(type);
                    continue;
                }
                result = JSONUtilities.mergeJsonObjects(result, cachedObject);
            }
            if (missingTypes.size() > 0) {
                T target = this.restore(targetId);
                for (JSONOutputType type : typeSet) {
                    String cacheId = targetId.hashCode() + "#" + type.toString();
                    JSONObject json = this.toJSON(target, type);
                    cache.cache(cacheId, json);
                    result = JSONUtilities.mergeJsonObjects(result, json);
                }
            }
        }
        return result;
    }

    private Set<JSONOutputType> extractTypes(JSONOutputType ... types) {
        HashSet<JSONOutputType> typeSet = new HashSet<JSONOutputType>();
        if (types.length == 0) {
            typeSet.add(JSONOutputType.BASIC);
        } else {
            for (JSONOutputType type : types) {
                if (JSONOutputType.ALL.equals((Object)type)) {
                    typeSet.add(JSONOutputType.BASIC);
                    typeSet.add(JSONOutputType.LINKED);
                    typeSet.add(JSONOutputType.SECURITY);
                    typeSet.add(JSONOutputType.EXTENDED);
                    continue;
                }
                typeSet.add(type);
            }
        }
        return typeSet;
    }
}

