/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.guice.spi.container.servlet;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Scope;
import com.google.inject.Singleton;
import com.google.inject.servlet.ServletScopes;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.guice.spi.container.GuiceComponentProviderFactory;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebConfig;
import java.util.Map;
import javax.servlet.ServletException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class GuiceContainer
extends ServletContainer {
    private final Injector injector;

    @Inject
    public GuiceContainer(Injector injector) {
        this.injector = injector;
    }

    protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig webConfig) throws ServletException {
        return new DefaultResourceConfig();
    }

    protected void initiate(ResourceConfig config, WebApplication webapp) {
        webapp.initiate(config, (IoCComponentProviderFactory)new ServletGuiceComponentProviderFactory(config, this.injector));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ServletGuiceComponentProviderFactory
    extends GuiceComponentProviderFactory {
        public ServletGuiceComponentProviderFactory(ResourceConfig config, Injector injector) {
            super(config, injector);
        }

        @Override
        public Map<Scope, ComponentScope> createScopeMap() {
            Map<Scope, ComponentScope> m = super.createScopeMap();
            m.put(ServletScopes.REQUEST, ComponentScope.PerRequest);
            return m;
        }
    }
}

