/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class RequestDefaultUserFilter
implements Filter {
    private static final Logger log = Logger.getLogger(RequestDefaultUserFilter.class);
    private String defaultUserName = null;

    public void init(FilterConfig config) throws ServletException {
        this.defaultUserName = config.getInitParameter("default.username");
        Validate.notEmpty((String)this.defaultUserName, (String)"default.username can not be empty");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestUserName = (String)request.getAttribute("currentUserName");
        String sessionUserName = null;
        if (HttpServletRequest.class.isInstance(request)) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            sessionUserName = (String)httpRequest.getSession().getAttribute("currentUserName");
        }
        String msg = "Found request user %s and session user %s";
        log.debug((Object)String.format(msg, requestUserName, sessionUserName));
        if (StringUtils.isEmpty((String)requestUserName) && StringUtils.isEmpty((String)sessionUserName)) {
            log.debug((Object)("Setting request user to " + this.defaultUserName));
            request.setAttribute("currentUserName", (Object)this.defaultUserName);
        }
        filterChain.doFilter(request, response);
    }
}

