/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import com.urbancode.release.rest.models.internal.Command;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import com.urbancode.release.rest.models.internal.Plugin;
import java.util.HashMap;
import java.util.Map;

public class PluginIntegrationProvider<T extends PluginIntegrationProvider>
extends IntegrationProvider<T> {
    @SerializedName(value="integrationPlugin")
    public Plugin plugin;
    public long integrationPluginVersion;
    public String pluginVersion;
    public String defaultStep;

    public PluginIntegrationProvider() {
        this.integrationType = IntegrationProvider.IntegrationProviderType.PLUGIN;
    }

    public PluginIntegrationProvider<T> plugin(Plugin plugin) {
        this.plugin = plugin;
        this.pluginVersion = plugin.getId();
        this.integrationPluginVersion = plugin.getPluginVersion();
        return this;
    }

    public PluginIntegrationProvider<T> defaultStep(Command command) {
        this.defaultStep = command.getName();
        return this;
    }

    public PluginIntegrationProvider<T> defaultStep(String command) {
        this.defaultStep = command;
        return this;
    }

    public Response runPluginStep(String stepName, String pluginId) {
        return this.runPluginStep(stepName, new HashMap<String, String>(), pluginId);
    }

    public Response runPluginStep(String stepName, Map<String, String> formValues, String pluginId) {
        String stepURL = "plugins/" + this.getId() + "/{pluginId}/{commandName}/execute/{propDefName}";
        stepURL = stepURL.replace("{pluginId}", pluginId).replace("{commandName}", this.defaultStep).replace("{propDefName}", stepName);
        RequestSpecification requestSpec = RestAssured.given().formParam("integrationProviderId", this.id);
        for (String key : formValues.keySet()) {
            requestSpec.formParam(key, formValues.get(key));
        }
        Response response = (Response)requestSpec.contentType(ContentType.URLENC).post(stepURL, new Object[0]);
        return response;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }
}

