/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.JsonObject;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.internal.ExternalLink;
import com.urbancode.release.rest.models.internal.VersionStatus;

public class Version
extends ClientIntegrated<Version> {
    public Application application;
    public Long createdDate;
    public Boolean automated;
    public Version[] children;
    @Deprecated
    public VersionStatus[] versionStatuses;
    public ExternalLink[] externalLinks;

    public Version() {
        this.path = "/versions/";
        this.oldPath = "/version/";
    }

    public Application getApplication() {
        return this.application;
    }

    public Version setApplication(Application application) {
        return this.application(application);
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public Version setCreatedDate(Long date) {
        return this.createdDate(date);
    }

    public Version application(Application application) {
        this.handleNull(application, "application");
        this.application = application;
        return this;
    }

    public Version createdDate(Long date) {
        this.createdDate = date;
        return this;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public Version setAutomated(boolean automated) {
        this.automated(automated);
        return this;
    }

    public Version automated(boolean automated) {
        this.automated = automated;
        return this;
    }

    public Version[] getChildren() {
        return this.children;
    }

    public Version setChildren(Version[] children) {
        this.children(children);
        return this;
    }

    public Version children(Version[] children) {
        this.children = children;
        return this;
    }

    public Version setVersionStatuses(VersionStatus[] versionStatuses) {
        this.versionStatuses(versionStatuses);
        return this;
    }

    public Version versionStatuses(VersionStatus[] versionStatuses) {
        this.versionStatuses = versionStatuses;
        return this;
    }

    public Version addExternalLink(ExternalLink link) {
        JsonObject json = new JsonObject();
        json.addProperty("name", link.name);
        json.addProperty("link", link.link);
        json.addProperty("description", link.description);
        this.query.apply(RestAssured.given()).body((Object)json, ObjectMapperType.GSON).post(this.path(this.id) + "/externalLink", new Object[0]);
        return this;
    }

    public Version addExternalLink(String name, String link, String description) {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        json.addProperty("link", link);
        json.addProperty("description", description);
        this.query.apply(RestAssured.given()).body((Object)json, ObjectMapperType.GSON).post(this.path(this.id) + "/externalLink", new Object[0]);
        return this;
    }

    public Version removeExternalLink(ExternalLink link) {
        this.query.apply(RestAssured.given()).delete(this.path(this.id) + "/externalLink/" + link.id, new Object[0]);
        return this;
    }

    @Deprecated
    public VersionStatus[] getVersionStatuses() {
        return this.versionStatuses;
    }

    public ExternalLink[] getExternalLinks() {
        return this.externalLinks;
    }
}

