/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.i18n;

import com.urbancode.air.i18n.TranslateUtil;
import com.urbancode.commons.util.JavaVersionComparator;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationJsonGenerator {
    private static final Logger log = Logger.getLogger((String)TranslationJsonGenerator.class.getName());
    private static TranslationJsonGenerator instance = null;

    public static TranslationJsonGenerator getInstance() {
        if (instance == null) {
            instance = new TranslationJsonGenerator();
        }
        return instance;
    }

    private static boolean isLatin1Bundle() {
        JavaVersionComparator cmp = new JavaVersionComparator();
        String version = System.getProperty("java.version");
        return cmp.compare("9", version) > 0;
    }

    public JSONObject generateJsonForLocale(Locale locale) {
        Properties properties = this.loadProperties(locale);
        return this.generateJson(properties);
    }

    private JSONObject generateJson(Properties properties) {
        JSONObject result = new JSONObject();
        if (!properties.isEmpty()) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                try {
                    if (value == null) {
                        result.put(key, JSONObject.NULL);
                        continue;
                    }
                    result.put(key, (Object)value);
                }
                catch (JSONException e) {
                    log.error((Object)"Could not generate JSON for i18n", (Throwable)e);
                }
            }
        }
        return result;
    }

    private Properties loadProperties(Locale locale) {
        String emptyValueOverride = TranslateUtil.getInstance().getEmptyValueOverride();
        String languageCode = locale.getLanguage();
        if ("dev_test".equalsIgnoreCase(languageCode)) {
            Properties defaultProperties = this.loadProperties(TranslateUtil.getDefaultLocale());
            Properties localeProperties = new Properties();
            for (Map.Entry<Object, Object> entry : defaultProperties.entrySet()) {
                String returnValue = emptyValueOverride != null ? emptyValueOverride : (String)entry.getKey();
                localeProperties.put(entry.getKey(), returnValue);
            }
            return localeProperties;
        }
        if ("default".equalsIgnoreCase(languageCode)) {
            locale = TranslateUtil.getDefaultLocale();
        }
        return this.loadProperties(TranslateUtil.getInstance().getResourceBundlesForLocale(locale));
    }

    private Properties loadProperties(List<ResourceBundle> bundles) {
        Properties properties = new Properties();
        for (ResourceBundle bundle : bundles) {
            for (String key : bundle.keySet()) {
                String rawValue = bundle.getString(key);
                try {
                    Locale bundleLocale = bundle.getLocale();
                    String utf8Value = "rpx".equals(bundleLocale.getLanguage()) ? rawValue : (TranslationJsonGenerator.isLatin1Bundle() ? new String(rawValue.getBytes("ISO-8859-1"), "UTF-8") : rawValue);
                    assert (!utf8Value.contains("\ufffd")) : "Found illegal character \ufffd in message for key " + key;
                    properties.put(key, utf8Value);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Could not convert string to UTF", e);
                }
            }
        }
        return properties;
    }
}

