/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.filters;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.web.util.RequestHelper;
import com.urbancode.commons.webext.util.InstalledProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AuthenticatedSessionFilter
implements Filter {
    private static final Logger log = Logger.getLogger(AuthenticatedSessionFilter.class);
    public static final String CURRENT_USERNAME = "currentUserName";
    public static final String LOGIN_URL_PARAM = "loginUrl";
    public static final String ALLOW_URLS_PARAM = "allowUrls";
    public static final String API_URLS_PARAM = "apiUrls";
    private static final String DEFAULT_LOGIN_URL = "/WEB-INF/login.jsp";
    private static final String DEFAULT_FORBIDDEN_TF_URL = "/WEB-INF/forbidden.jsp";
    private String loginUrl = "/WEB-INF/login.jsp";
    private Set<Pattern> allowUrlPatterns = new HashSet<Pattern>();
    private Set<Pattern> apiUrlPatterns = new HashSet<Pattern>();

    public void init(FilterConfig config) throws ServletException {
        String loginUrl = config.getInitParameter(LOGIN_URL_PARAM);
        if (StringUtils.isNotEmpty((String)loginUrl)) {
            this.loginUrl = loginUrl;
        }
        String allowUrls = config.getInitParameter(ALLOW_URLS_PARAM);
        this.allowUrlPatterns.clear();
        if (StringUtils.isNotEmpty((String)allowUrls)) {
            for (String patternString : allowUrls.split("[,\\s]+")) {
                this.allowUrlPatterns.add(Pattern.compile(patternString.trim()));
            }
        }
        String apiUrls = config.getInitParameter(API_URLS_PARAM);
        this.apiUrlPatterns.clear();
        if (StringUtils.isNotEmpty((String)apiUrls)) {
            for (String patternString : apiUrls.split("[,\\s]+")) {
                if ((patternString = patternString.trim()).length() <= 0) continue;
                this.apiUrlPatterns.add(Pattern.compile(patternString));
            }
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (HttpServletRequest.class.isInstance(request) && HttpServletResponse.class.isInstance(response)) {
            String authenticatedUser;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            HttpSession session = httpRequest.getSession();
            boolean doAllow = false;
            String path = StringUtils.removeStart((String)httpRequest.getRequestURI(), (String)httpRequest.getContextPath());
            for (Pattern allow : this.allowUrlPatterns) {
                if (!allow.matcher(path).matches()) continue;
                doAllow = true;
                break;
            }
            if (StringUtils.isEmpty((String)(authenticatedUser = (String)request.getAttribute(CURRENT_USERNAME)))) {
                authenticatedUser = (String)session.getAttribute(CURRENT_USERNAME);
            }
            if (StringUtils.isNotEmpty((String)authenticatedUser)) {
                log.trace((Object)("found authenticated user " + authenticatedUser));
                request.setAttribute(CURRENT_USERNAME, (Object)authenticatedUser);
            } else if (doAllow) {
                log.trace((Object)("forwarding for non-authenticated path " + path));
                request.setAttribute(CURRENT_USERNAME, (Object)"anthill");
            } else {
                String servletPath = httpRequest.getServletPath();
                boolean isApi = false;
                for (Pattern api : this.apiUrlPatterns) {
                    if (!api.matcher(servletPath).matches()) continue;
                    isApi = true;
                    break;
                }
                if (isApi) {
                    InstalledProperties installedProps = new InstalledProperties();
                    RequestHelper requestHelper = new RequestHelper();
                    if (requestHelper.isToolUserAgent(httpRequest)) {
                        String serverName = StringUtils.defaultIfEmpty((String)installedProps.getProperty("server.name"), (String)"Anthill3");
                        httpResponse.setHeader("WWW-Authenticate", String.format("Basic realm=\"%s\"", serverName));
                    }
                    httpResponse.setStatus(401);
                    httpResponse.setContentType("text/plain");
                    ServletOutputStream os = httpResponse.getOutputStream();
                    try {
                        IO.writeText((OutputStream)os, (CharSequence)"401 Unauthorized");
                    }
                    finally {
                        IO.close((OutputStream)os);
                    }
                } else if (request.getParameter("fromTeamforge") != null) {
                    httpRequest.getRequestDispatcher(DEFAULT_FORBIDDEN_TF_URL).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                } else {
                    httpRequest.getRequestDispatcher(this.loginUrl).forward((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
        }
        if (!response.isCommitted()) {
            filterChain.doFilter(request, response);
        }
    }
}

