/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONUtilities {
    public static String getStringFromJsonObject(JSONObject object, String name) {
        String result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getString(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static UUID getUUIDFromJsonObject(JSONObject object, String name) {
        UUID result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                String stringResult = object.getString(name);
                if (stringResult != null && !StringUtils.isEmpty((String)stringResult)) {
                    result = UUID.fromString(stringResult);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Boolean getBooleanFromJsonObject(JSONObject object, String name) {
        Boolean result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getBoolean(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Double getDoubleFromJsonObject(JSONObject object, String name) {
        Double result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getDouble(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Integer getIntegerFromJsonObject(JSONObject object, String name) {
        Integer result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getInt(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Long getLongFromJsonObject(JSONObject object, String name) {
        Long result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getLong(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static JSONObject getJsonObjectFromJsonObject(JSONObject object, String name) {
        JSONObject result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getJSONObject(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static JSONArray getJsonArrayFromJsonObject(JSONObject object, String name) {
        JSONArray result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.getJSONArray(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Object getObjectFromJsonObject(JSONObject object, String name) {
        Object result = null;
        if (object.has(name) && !object.isNull(name)) {
            try {
                result = object.get(name);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return result;
    }

    public static JSONObject mergeJsonObjects(JSONObject object1, JSONObject object2) throws JSONException {
        JSONObject result = new JSONObject();
        Iterator keys1 = object1.keys();
        while (keys1.hasNext()) {
            String key = (String)keys1.next();
            result.put(key, object1.get(key));
        }
        Iterator keys2 = object2.keys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            Object value = object2.get(key);
            if (result.has(key)) {
                Object existingValue = result.get(key);
                if (existingValue.toString().equals(value.toString())) continue;
                throw new IllegalArgumentException("Cannot merge two JSONObjects with different values for the same key: " + key + " = " + value + " / " + existingValue);
            }
            result.put(key, value);
        }
        return result;
    }

    public static JSONArray getOrCreateChildrenArrayByPath(JSONArray array, String path) throws Exception {
        String[] pathParts = path.split("/");
        JSONArray result = JSONUtilities.getOrCreateChildrenArray(array, pathParts);
        return result;
    }

    public static void changeValue(String attName, Object attValue, Object newValue, JSONObject json) throws JSONException {
        Iterator i = json.keys();
        while (i.hasNext()) {
            String keyName = (String)i.next();
            Object value = json.get(keyName);
            if (value instanceof JSONObject) {
                JSONUtilities.changeValue(attName, attValue, newValue, (JSONObject)value);
                continue;
            }
            if (value instanceof JSONArray) {
                JSONUtilities.changeValue(attName, attValue, newValue, (JSONArray)value);
                continue;
            }
            if (!attName.equals(keyName) || !value.equals(attValue)) continue;
            json.put(keyName, newValue);
        }
    }

    public static void changeValue(String attName, Object attValue, Object newValue, JSONArray json) throws JSONException {
        for (int i = 0; i < json.length(); ++i) {
            Object value = json.get(i);
            if (value instanceof JSONObject) {
                JSONUtilities.changeValue(attName, attValue, newValue, (JSONObject)value);
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            JSONUtilities.changeValue(attName, attValue, newValue, (JSONArray)value);
        }
    }

    public static JSONArray getOrCreateChildrenArray(JSONArray array, String ... pathParts) throws JSONException {
        JSONArray result = array;
        String currentPath = "";
        for (String pathPart : pathParts) {
            if (currentPath.length() > 0) {
                currentPath = currentPath + "/";
            }
            currentPath = currentPath + pathPart;
            boolean foundChild = false;
            for (int i = 0; i < result.length(); ++i) {
                JSONObject child = result.getJSONObject(i);
                String childName = JSONUtilities.getStringFromJsonObject(child, "name");
                if (!StringUtils.equals((String)pathPart, (String)childName)) continue;
                result = JSONUtilities.getJsonArrayFromJsonObject(child, "children");
                if (result == null) {
                    result = new JSONArray();
                    child.put("children", (Object)result);
                }
                foundChild = true;
                break;
            }
            if (foundChild) continue;
            JSONObject child = new JSONObject();
            child.put("id", (Object)currentPath);
            child.put("name", (Object)pathPart);
            result.put((Object)child);
            result = new JSONArray();
            child.put("children", (Object)result);
        }
        return result;
    }

    public static Response jsonArrayToResponse(JSONArray jsonArray) {
        Response response = Response.ok((Object)jsonArray).header("Content-Range", (Object)("items 0-" + (jsonArray.length() - 1) + "/" + jsonArray.length())).header("Content-Type", (Object)"application/json").build();
        return response;
    }

    public static UUID attemptUUIDConversion(String string) {
        UUID result = null;
        if (string != null) {
            try {
                result = UUID.fromString(string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public static List<JSONObject> convertJSONArrayToList(JSONArray array) throws JSONException {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (int i = 0; i < array.length(); ++i) {
            result.add(array.getJSONObject(i));
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONObjectStringComparator
    implements Comparator<JSONObject> {
        private String propertyName;

        public JSONObjectStringComparator(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public int compare(JSONObject jsonObject1, JSONObject jsonObject2) {
            String name1 = JSONUtilities.getStringFromJsonObject(jsonObject1, this.propertyName);
            String name2 = JSONUtilities.getStringFromJsonObject(jsonObject2, this.propertyName);
            int result = 0;
            result = name1 == null ? -1 : (name2 == null ? 1 : name1.compareToIgnoreCase(name2));
            return result;
        }
    }
}

