/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.jira;

import org.codehaus.jettison.json.JSONObject;
import com.urbancode.commons.webext.util.JSONUtilities;
import javax.ws.rs.core.Response;

public class JiraApplication {

    //**********************************************************************************************
    // CLASS
    //**********************************************************************************************

    //**********************************************************************************************
    // INSTANCE
    //**********************************************************************************************
    final private String name;
    final private String id;
    private List<JiraRelease> versions = new ArrayList<JiraRelease>();
    private List<JiraComponent> components = new ArrayList<JiraComponent>();

    //----------------------------------------------------------------------------------------------
    public JiraApplication(JSONObject json) {
        name = JSONUtilities.getStringFromJsonObject(json, "name");
        id = JSONUtilities.getStringFromJsonObject(json, "id");
    }

    //----------------------------------------------------------------------------------------------
    public String getName() {
        return name;
    }

    //----------------------------------------------------------------------------------------------
    public String getId() {
        return id;
    }

    //----------------------------------------------------------------------------------------------
    public List<JiraRelease> getVersions() {
        return versions;
    }

    //----------------------------------------------------------------------------------------------
    public void setVersions(List<JiraRelease> versions) {
        this.versions = versions;
    }

    //----------------------------------------------------------------------------------------------
    public List<JiraComponent> getComponents() {
        return components;
    }

    //----------------------------------------------------------------------------------------------
    public void setComponents(List<JiraComponent> components) {
        this.components = components;
    }
}
