/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.jira;

import org.codehaus.jettison.json.JSONObject;
import com.urbancode.commons.webext.util.JSONUtilities;

public class JiraRelease {

    //**********************************************************************************************
    // CLASS
    //**********************************************************************************************

    //**********************************************************************************************
    // INSTANCE
    //**********************************************************************************************
    final private String name;
    final private String id;
    final private long releaseDate;
    final private boolean archived;
    final private boolean released;


    //----------------------------------------------------------------------------------------------
    public JiraRelease(JSONObject json) {
        name = JSONUtilities.getStringFromJsonObject(json, "name");
        id = JSONUtilities.getStringFromJsonObject(json, "id");
        String tempReleaseDate = JSONUtilities.getStringFromJsonObject(json, "releaseDate");

        if (tempReleaseDate) {
            releaseDate = Date.parse("yyyy-MM-dd", tempReleaseDate).getTime()
        } else {
            releaseDate = -1
        }
        archived = JSONUtilities.getBooleanFromJsonObject(json, "archived");
        released = JSONUtilities.getBooleanFromJsonObject(json, "released");
    }

    //----------------------------------------------------------------------------------------------
    public String getName() {
        return name;
    }

    //----------------------------------------------------------------------------------------------
    public String getId() {
        return id;
    }

    //----------------------------------------------------------------------------------------------
    public long getReleaseDate() {
        return releaseDate;
    }
}
