/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.QueryParams;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.ChangeType;
import com.urbancode.release.rest.models.Initiative;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.internal.IntegrationProvider;
import java.util.HashMap;

public class Change
extends ClientIntegrated<Change> {
    public ChangeType type;
    public Status status;
    public Severity severity;
    public Initiative initiative;
    public Release release;
    public Application application;

    public Change() {
        this.path = "/changes/";
    }

    public ChangeType getType() {
        return this.type;
    }

    public Change setType(ChangeType type) {
        return this.type(type);
    }

    public Change type(ChangeType type) {
        this.type = type;
        return this;
    }

    public Status getStatus() {
        return this.status;
    }

    public Change setStatus(Status status) {
        return this.status(status);
    }

    public Change status(Status status) {
        this.status = status;
        return this;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public Change setSeverity(Severity severity) {
        return this.severity(severity);
    }

    public Change severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public Initiative getInitiative() {
        return this.initiative;
    }

    public Change setInitiative(Initiative initiative) {
        return this.initiative(initiative);
    }

    public Change initiative(Initiative initiative) {
        this.handleNull(initiative, "initiative");
        this.initiative = initiative;
        return this;
    }

    public Release getRelease() {
        return this.release;
    }

    public Change setRelease(Release release) {
        return this.release(release);
    }

    public Change release(Release release) {
        this.handleNull(release, "release");
        this.release = release;
        return this;
    }

    @Override
    public IntegrationProvider<?> getIntegrationProvider() {
        return this.integrationProvider;
    }

    public Application getApplication() {
        return this.application;
    }

    public Change setApplication(Application application) {
        return this.application(application);
    }

    public Change application(Application application) {
        this.handleNull(application, "application");
        this.application = application;
        return this;
    }

    @Deprecated
    public Change[] getAllForIntegrationProvider(String integrationProviderId) {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "allForProvider/" + integrationProviderId, new Object[0])).as(Change[].class, ObjectMapperType.GSON);
    }

    public Change[] getAllForExternalIds(String provider, String externalIds) {
        QueryParams query = new QueryParams().param("externalIds", externalIds);
        return ((Response)query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.path() + "changesForProvider/" + provider, new Object[0])).as(Change[].class, ObjectMapperType.GSON);
    }

    @Deprecated
    public void deleteAllForIntegrationProvider(String integrationProviderId) {
        this.query.apply(RestAssured.given()).when().delete(this.path() + "allForProvider/" + integrationProviderId, new Object[0]);
    }

    @Deprecated
    public NameValueMap getStatuses() {
        return ((Response)RestAssured.given().get(this.path() + "statuses", new Object[0])).as(NameValueMap.class, ObjectMapperType.GSON);
    }

    protected static class ChangesUpdate {
        public ChangeAssociation type;
        public String id;
        public String[] changes;

        protected ChangesUpdate() {
        }

        public ChangeAssociation getType() {
            return this.type;
        }

        public ChangesUpdate setType(ChangeAssociation type) {
            return this.type(type);
        }

        public ChangesUpdate type(ChangeAssociation type) {
            this.type = type;
            return this;
        }

        public String getId() {
            return this.id;
        }

        public ChangesUpdate setId(String id) {
            return this.id(id);
        }

        public ChangesUpdate id(String id) {
            this.id = id;
            return this;
        }

        public String[] getChanges() {
            return this.changes;
        }

        public ChangesUpdate setChanges(Change ... changes) {
            return this.changes(changes);
        }

        public ChangesUpdate changes(Change ... changes) {
            this.changes = ClientEntity.ids(changes);
            return this;
        }

        public Response send() {
            return (Response)RestAssured.given().contentType(ContentType.JSON).body((Object)this, ObjectMapperType.GSON).put(Clients.change().path() + "update", new Object[0]);
        }
    }

    protected static enum ChangeAssociation {
        RELEASE,
        APPLICATION,
        INITIATIVE,
        TYPE;

    }

    public static class NameValueMap
    extends HashMap<String, String> {
    }

    public static enum Severity {
        S1,
        S2,
        OTHER;

    }

    public static enum Status {
        NONE("None"),
        NEW("New"),
        IN_PROGRESS("In Progress"),
        COMPLETED("Completed"),
        ACCEPTED("Accepted");

        private String statusName;

        private Status(String statusName) {
            this.statusName = statusName;
        }

        public String toString() {
            return this.statusName;
        }
    }
}

