/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.log4j.Logger;

public class InstalledVersion {
    private static InstalledVersion instance = new InstalledVersion();
    private static final Logger log = Logger.getLogger(InstalledVersion.class);
    private String version = null;

    public static synchronized InstalledVersion getInstance() {
        return instance;
    }

    private InstalledVersion() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVersion() {
        if (this.version == null) {
            Properties versionProps = new Properties();
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = cl.getResourceAsStream("installed.version");
            if (in == null) {
                log.error((Object)"Could not locate installed.version file in the classpath!!!");
            } else {
                try {
                    versionProps.load(in);
                    this.version = versionProps.getProperty("installed.version");
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return this.version;
    }
}

