/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl.coll;

import com.ibm.icu.impl.ICUBinary;
import com.ibm.icu.impl.Trie2_32;
import com.ibm.icu.impl.USerializedSet;
import com.ibm.icu.impl.coll.CollationData;
import com.ibm.icu.impl.coll.CollationFastLatin;
import com.ibm.icu.impl.coll.CollationSettings;
import com.ibm.icu.impl.coll.CollationTailoring;
import com.ibm.icu.text.UnicodeSet;
import com.ibm.icu.util.ICUException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

final class CollationDataReader {
    static final int IX_INDEXES_LENGTH = 0;
    static final int IX_OPTIONS = 1;
    static final int IX_RESERVED2 = 2;
    static final int IX_RESERVED3 = 3;
    static final int IX_JAMO_CE32S_START = 4;
    static final int IX_REORDER_CODES_OFFSET = 5;
    static final int IX_REORDER_TABLE_OFFSET = 6;
    static final int IX_TRIE_OFFSET = 7;
    static final int IX_RESERVED8_OFFSET = 8;
    static final int IX_CES_OFFSET = 9;
    static final int IX_RESERVED10_OFFSET = 10;
    static final int IX_CE32S_OFFSET = 11;
    static final int IX_ROOT_ELEMENTS_OFFSET = 12;
    static final int IX_CONTEXTS_OFFSET = 13;
    static final int IX_UNSAFE_BWD_OFFSET = 14;
    static final int IX_FAST_LATIN_TABLE_OFFSET = 15;
    static final int IX_SCRIPTS_OFFSET = 16;
    static final int IX_COMPRESSIBLE_BYTES_OFFSET = 17;
    static final int IX_RESERVED18_OFFSET = 18;
    static final int IX_TOTAL_SIZE = 19;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final byte[] DATA_FORMAT = new byte[]{85, 67, 111, 108};

    static void read(CollationTailoring base, InputStream inBytes, CollationTailoring tailoring) throws IOException {
        int i;
        int i2;
        int[] reorderCodes;
        int i3;
        BufferedInputStream bis = new BufferedInputStream(inBytes);
        tailoring.version = ICUBinary.readHeaderAndDataVersion(bis, DATA_FORMAT, IS_ACCEPTABLE);
        if (base != null && base.getUCAVersion() != tailoring.getUCAVersion()) {
            throw new ICUException("Tailoring UCA version differs from base data UCA version");
        }
        DataInputStream ds = new DataInputStream(bis);
        int indexesLength = ds.readInt();
        if (indexesLength < 2) {
            throw new ICUException("not enough indexes");
        }
        int[] inIndexes = new int[20];
        inIndexes[0] = indexesLength;
        for (i3 = 1; i3 < indexesLength && i3 < inIndexes.length; ++i3) {
            inIndexes[i3] = ds.readInt();
        }
        for (i3 = indexesLength; i3 < inIndexes.length; ++i3) {
            inIndexes[i3] = -1;
        }
        if (indexesLength > inIndexes.length) {
            ds.skipBytes((indexesLength - inIndexes.length) * 4);
        }
        CollationData baseData = base == null ? null : base.data;
        int index = 5;
        int offset = inIndexes[index];
        int length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            if (baseData == null) {
                throw new ICUException("Collation base data must not reorder scripts");
            }
            reorderCodes = new int[length / 4];
            for (int i4 = 0; i4 < length / 4; ++i4) {
                reorderCodes[i4] = ds.readInt();
            }
            length &= 3;
        } else {
            reorderCodes = new int[]{};
        }
        ds.skipBytes(length);
        byte[] reorderTable = null;
        index = 6;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 256) {
            if (reorderCodes.length == 0) {
                throw new ICUException("Reordering table without reordering codes");
            }
            reorderTable = new byte[256];
            ds.readFully(reorderTable);
            length -= 256;
        }
        ds.skipBytes(length);
        if (baseData != null && baseData.numericPrimary != ((long)inIndexes[1] & 0xFF000000L)) {
            throw new ICUException("Tailoring numeric primary weight differs from base data");
        }
        CollationData data = null;
        index = 7;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 8) {
            tailoring.ensureOwnedData();
            data = tailoring.ownedData;
            data.base = baseData;
            data.numericPrimary = (long)inIndexes[1] & 0xFF000000L;
            data.trie = tailoring.trie = Trie2_32.createFromSerialized(ds);
            int trieLength = data.trie.getSerializedLength();
            if (trieLength > length) {
                throw new ICUException("Not enough bytes for the mappings trie");
            }
            length -= trieLength;
        } else if (baseData != null) {
            tailoring.data = baseData;
        } else {
            throw new ICUException("Missing collation data mappings");
        }
        ds.skipBytes(length);
        index = 8;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ds.skipBytes(length);
        index = 9;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 8) {
            if (data == null) {
                throw new ICUException("Tailored ces without tailored trie");
            }
            data.ces = new long[length / 8];
            for (i2 = 0; i2 < length / 8; ++i2) {
                data.ces[i2] = ds.readLong();
            }
            length &= 7;
        }
        ds.skipBytes(length);
        index = 10;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ds.skipBytes(length);
        index = 11;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            if (data == null) {
                throw new ICUException("Tailored ce32s without tailored trie");
            }
            data.ce32s = new int[length / 4];
            for (i2 = 0; i2 < length / 4; ++i2) {
                data.ce32s[i2] = ds.readInt();
            }
            length &= 3;
        }
        ds.skipBytes(length);
        int jamoCE32sStart = inIndexes[4];
        if (jamoCE32sStart >= 0) {
            if (data == null || data.ce32s == null) {
                throw new ICUException("JamoCE32sStart index into non-existent ce32s[]");
            }
            data.jamoCE32s = new int[67];
            System.arraycopy(data.ce32s, jamoCE32sStart, data.jamoCE32s, 0, 67);
        } else if (data != null) {
            if (baseData != null) {
                data.jamoCE32s = baseData.jamoCE32s;
            } else {
                throw new ICUException("Missing Jamo CE32s for Hangul processing");
            }
        }
        index = 12;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 4) {
            int rootElementsLength = length / 4;
            if (data == null) {
                throw new ICUException("Root elements but no mappings");
            }
            if (rootElementsLength <= 4) {
                throw new ICUException("Root elements array too short");
            }
            data.rootElements = new long[rootElementsLength];
            for (int i5 = 0; i5 < rootElementsLength; ++i5) {
                data.rootElements[i5] = (long)ds.readInt() & 0xFFFFFFFFL;
            }
            long commonSecTer = data.rootElements[3];
            if (commonSecTer != 0x5000500L) {
                throw new ICUException("Common sec/ter weights in base data differ from the hardcoded value");
            }
            long secTerBoundaries = data.rootElements[4];
            if (secTerBoundaries >>> 24 < 69L) {
                throw new ICUException("[fixed last secondary common byte] is too low");
            }
            length &= 3;
        }
        ds.skipBytes(length);
        index = 13;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Tailored contexts without tailored trie");
            }
            StringBuilder sb = new StringBuilder(length / 2);
            for (int i6 = 0; i6 < length / 2; ++i6) {
                sb.append(ds.readChar());
            }
            data.contexts = sb.toString();
            length &= 1;
        }
        ds.skipBytes(length);
        index = 14;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Unsafe-backward-set but no mappings");
            }
            if (baseData == null) {
                tailoring.unsafeBackwardSet = new UnicodeSet(56320, 57343);
                data.nfcImpl.addLcccChars(tailoring.unsafeBackwardSet);
            } else {
                tailoring.unsafeBackwardSet = baseData.unsafeBackwardSet.cloneAsThawed();
            }
            USerializedSet sset = new USerializedSet();
            char[] unsafeData = new char[length / 2];
            for (i = 0; i < length / 2; ++i) {
                unsafeData[i] = ds.readChar();
            }
            length &= 1;
            sset.getSet(unsafeData, 0);
            int count = sset.countRanges();
            int[] range = new int[2];
            for (int i7 = 0; i7 < count; ++i7) {
                sset.getRange(i7, range);
                tailoring.unsafeBackwardSet.add(range[0], range[1]);
            }
            int c = 65536;
            int lead = 55296;
            while (lead < 56320) {
                if (!tailoring.unsafeBackwardSet.containsNone(c, c + 1023)) {
                    tailoring.unsafeBackwardSet.add(lead);
                }
                ++lead;
                c += 1024;
            }
            tailoring.unsafeBackwardSet.freeze();
            data.unsafeBackwardSet = tailoring.unsafeBackwardSet;
        } else if (data != null) {
            if (baseData != null) {
                data.unsafeBackwardSet = baseData.unsafeBackwardSet;
            } else {
                throw new ICUException("Missing unsafe-backward-set");
            }
        }
        ds.skipBytes(length);
        index = 15;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (data != null) {
            data.fastLatinTable = null;
            data.fastLatinTableHeader = null;
            if ((inIndexes[1] >> 16 & 0xFF) == 1) {
                if (length >= 2) {
                    char header0 = ds.readChar();
                    int headerLength = header0 & 0xFF;
                    data.fastLatinTableHeader = new char[headerLength];
                    data.fastLatinTableHeader[0] = header0;
                    for (i = 1; i < headerLength; ++i) {
                        data.fastLatinTableHeader[i] = ds.readChar();
                    }
                    int tableLength = length / 2 - headerLength;
                    data.fastLatinTable = new char[tableLength];
                    for (int i8 = 0; i8 < tableLength; ++i8) {
                        data.fastLatinTable[i8] = ds.readChar();
                    }
                    length &= 1;
                    if (header0 >> 8 != 1) {
                        throw new ICUException("Fast-Latin table version differs from version in data header");
                    }
                } else if (baseData != null) {
                    data.fastLatinTable = baseData.fastLatinTable;
                    data.fastLatinTableHeader = baseData.fastLatinTableHeader;
                }
            }
        }
        ds.skipBytes(length);
        index = 16;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 2) {
            if (data == null) {
                throw new ICUException("Script order data but no mappings");
            }
            data.scripts = new char[length / 2];
            for (int i9 = 0; i9 < length / 2; ++i9) {
                data.scripts[i9] = ds.readChar();
            }
            length &= 1;
        } else if (data != null && baseData != null) {
            data.scripts = baseData.scripts;
        }
        ds.skipBytes(length);
        index = 17;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        if (length >= 256) {
            if (data == null) {
                throw new ICUException("Data for compressible primary lead bytes but no mappings");
            }
            data.compressibleBytes = new boolean[256];
            for (int i10 = 0; i10 < 256; ++i10) {
                data.compressibleBytes[i10] = ds.readBoolean();
            }
            length -= 256;
        } else if (data != null) {
            if (baseData != null) {
                data.compressibleBytes = baseData.compressibleBytes;
            } else {
                throw new ICUException("Missing data for compressible primary lead bytes");
            }
        }
        ds.skipBytes(length);
        index = 18;
        offset = inIndexes[index];
        length = inIndexes[index + 1] - offset;
        ds.skipBytes(length);
        ds.close();
        CollationSettings ts = tailoring.settings.readOnly();
        int options = inIndexes[1] & 0xFFFF;
        char[] fastLatinPrimaries = new char[384];
        int fastLatinOptions = CollationFastLatin.getOptions(tailoring.data, ts, fastLatinPrimaries);
        if (options == ts.options && ts.variableTop != 0L && Arrays.equals(reorderCodes, ts.reorderCodes) && fastLatinOptions == ts.fastLatinOptions && (fastLatinOptions < 0 || Arrays.equals(fastLatinPrimaries, ts.fastLatinPrimaries))) {
            return;
        }
        CollationSettings settings = tailoring.settings.copyOnWrite();
        settings.options = options;
        settings.variableTop = tailoring.data.getLastPrimaryForGroup(4096 + settings.getMaxVariable());
        if (settings.variableTop == 0L) {
            throw new ICUException("The maxVariable could not be mapped to a variableTop");
        }
        if (reorderCodes.length == 0 || reorderTable != null) {
            settings.setReordering(reorderCodes, reorderTable);
        } else {
            byte[] table = new byte[256];
            baseData.makeReorderTable(reorderCodes, table);
            settings.setReordering(reorderCodes, table);
        }
        settings.fastLatinOptions = CollationFastLatin.getOptions(tailoring.data, settings, settings.fastLatinPrimaries);
    }

    private CollationDataReader() {
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        public boolean isDataVersionAcceptable(byte[] version) {
            return version[0] == 4;
        }
    }
}

