/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.mapper.ObjectMapper;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.VersionStatus;
import java.io.File;

public class VersionStatusAttachment
extends ClientEntity<VersionStatusAttachment> {
    @JsonReadOnly
    public VersionStatus versionStatus;
    @JsonReadOnly
    public String description;
    @JsonReadOnly
    private String versionStatusId;
    @JsonReadOnly
    private File file;

    public VersionStatusAttachment() {
        this.path = "/versionStatusAttachment/";
    }

    public VersionStatusAttachment file(File file) {
        this.file = file;
        return this;
    }

    public VersionStatusAttachment versionStatus(VersionStatus versionStatus) {
        this.versionStatus = versionStatus;
        this.versionStatusId = versionStatus.getId();
        return this;
    }

    public VersionStatusAttachment versionStatus(String versionStatusId) {
        this.versionStatusId = versionStatusId;
        return this;
    }

    public VersionStatusAttachment description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public VersionStatusAttachment save() {
        if (this.description == null) {
            this.description = "";
        }
        RestAssured.given().contentType("multipart/form-data").multiPart("description", this.description).multiPart("modelID", this.versionStatusId).multiPart("fileName", this.file.getName()).multiPart("file", this.file).expect().statusCode(200).when().post(this.path + "importAttachment", new Object[0]);
        return this;
    }

    public byte[] download() {
        return RestAssured.get(this.path + this.versionStatusId + "/" + this.file, new Object[0]).asByteArray();
    }

    protected VersionStatusAttachment[] getAttachmentForVersion(String versionStatusId, String fileName) {
        return RestAssured.get(this.path + versionStatusId + "/" + fileName, new Object[0]).as(VersionStatusAttachment[].class, ObjectMapper.GSON);
    }
}

