/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.zipwriter;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.CollectionUtil;
import com.urbancode.commons.util.unix.UMask;
import com.urbancode.commons.util.unix.UnixPermissions;
import com.urbancode.commons.util.zipwriter.InfoZipUtil;
import com.urbancode.commons.util.zipwriter.ZipContentItem;
import java.util.Set;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@BridgeMethodsAdded
abstract class ZipContentItemBase
extends ZipContentItem {
    private final String path;
    private final long timestamp;
    private final UnixPermissions permissions;

    ZipContentItemBase(String path, long timestamp, Set<?> permissionViews) {
        permissionViews = CollectionUtil.copySet(permissionViews);
        Check.nonBlank(path, "path");
        Check.allNonNull(permissionViews, "permissionViews");
        UnixPermissions permissions = null;
        for (Object view : permissionViews) {
            if (!(view instanceof UnixPermissions)) continue;
            permissions = (UnixPermissions)view;
        }
        this.path = path.trim();
        this.timestamp = timestamp;
        this.permissions = permissions;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void configureEntry(ZipArchiveEntry entry) {
        InfoZipUtil.Type type = this.getType();
        int mode = type.getDefaultMode(UMask.getGlobalInstance());
        if (this.permissions != null) {
            mode = this.permissions.getMode();
        }
        entry.setUnixMode(InfoZipUtil.createUnixMode(type, mode));
        if (this.timestamp != 0L) {
            entry.addExtraField(InfoZipUtil.createTimestampField(this.timestamp));
            entry.setTime(this.timestamp);
        }
    }

    abstract InfoZipUtil.Type getType();
}

