/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import com.urbancode.commons.webext.util.JSONUtilities;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParam<V> {
    private static final Logger log = Logger.getLogger(AbstractParam.class);
    private final String originalParam;
    private V value;

    public AbstractParam(String param) {
        this.originalParam = param;
    }

    public AbstractParam(V value) {
        this.value = value;
        this.originalParam = null;
    }

    public V getValue() {
        if (this.value == null) {
            try {
                this.value = this.parse(this.originalParam);
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new WebApplicationException(e, this.onError(this.originalParam, e));
            }
        }
        return this.value;
    }

    public String getOriginalParam() {
        return this.originalParam;
    }

    public String toString() {
        return this.getValue().toString();
    }

    protected abstract V parse(String var1) throws Throwable;

    protected Response onError(String param, Throwable e) {
        log.debug((Object)e.getMessage(), e);
        if (e instanceof SecurityException) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.getErrorMessage(param, e)).build();
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.getErrorMessage(param, e)).build();
    }

    protected String getErrorMessage(String param, Throwable e) {
        return "Invalid parameter: " + param + " (" + e.getMessage() + ")";
    }

    protected UUID attemptUUIDConversion(String string) {
        return JSONUtilities.attemptUUIDConversion(string);
    }

    protected void throwNotFoundException(String responseText) {
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)responseText).type(MediaType.TEXT_PLAIN_TYPE).build());
    }
}

