/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.i18n;

import com.urbancode.air.i18n.TranslateUtil;
import java.util.Locale;

public class TranslatableException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String message;
    private final Object[] arguments;
    private final Locale locale;
    private int status;

    public TranslatableException(String message, Object ... arguments) {
        this.message = message;
        this.arguments = arguments;
        this.status = 400;
        this.locale = TranslateUtil.getInstance().getCurrentLocale();
    }

    public TranslatableException(String message, Throwable cause, Object ... arguments) {
        super(cause);
        this.message = message;
        this.arguments = arguments;
        this.status = 400;
        this.locale = TranslateUtil.getInstance().getCurrentLocale();
    }

    public String getMessage() {
        return TranslateUtil.getInstance().substituteWildcards(this.message, this.arguments);
    }

    public String getTranslatedMessage() {
        TranslateUtil util = TranslateUtil.getInstance();
        Locale currentLocale = TranslateUtil.getInstance().getCurrentLocale();
        TranslateUtil.getInstance().setCurrentLocale(this.locale);
        String result = util.getValue(this.message, this.arguments);
        TranslateUtil.getInstance().setCurrentLocale(currentLocale);
        return result;
    }

    public TranslatableException setStatus(int status) {
        this.status = status;
        return this;
    }

    public int getStatus() {
        return this.status;
    }
}

