/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.config;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecoderConfig {
    private final String defaultContentCharset;
    private final List<ContentDecoder> contentDecoders;

    public DecoderConfig() {
        this(Charset.defaultCharset().toString(), DecoderConfig.defaultContentEncoders());
    }

    public DecoderConfig(String defaultContentCharset) {
        this(defaultContentCharset, DecoderConfig.defaultContentEncoders());
    }

    public DecoderConfig(ContentDecoder contentDecoder, ContentDecoder ... additionalContentDecoders) {
        this(Charset.defaultCharset().toString(), DecoderConfig.merge(contentDecoder, additionalContentDecoders));
    }

    private DecoderConfig(String defaultContentCharset, ContentDecoder ... contentDecoders) {
        Validate.notBlank(defaultContentCharset, "Default decoder content charset to cannot be blank", new Object[0]);
        this.defaultContentCharset = defaultContentCharset;
        this.contentDecoders = Collections.unmodifiableList(contentDecoders == null ? Collections.emptyList() : Arrays.asList(contentDecoders));
    }

    public String defaultContentCharset() {
        return this.defaultContentCharset;
    }

    public List<ContentDecoder> contentDecoders() {
        return this.contentDecoders;
    }

    public DecoderConfig defaultContentCharset(String charset) {
        return new DecoderConfig(charset);
    }

    public DecoderConfig contentDecoders(ContentDecoder contentDecoder, ContentDecoder ... additionalContentDecoders) {
        return new DecoderConfig(this.defaultContentCharset, DecoderConfig.merge(contentDecoder, additionalContentDecoders));
    }

    public DecoderConfig noContentDecoders() {
        return new DecoderConfig(this.defaultContentCharset, new ContentDecoder[0]);
    }

    public static DecoderConfig decoderConfig() {
        return new DecoderConfig();
    }

    public DecoderConfig and() {
        return this;
    }

    public DecoderConfig with() {
        return this;
    }

    private static ContentDecoder[] defaultContentEncoders() {
        return new ContentDecoder[]{ContentDecoder.GZIP, ContentDecoder.DEFLATE};
    }

    private static ContentDecoder[] merge(ContentDecoder contentDecoder, ContentDecoder[] additionalContentDecoders) {
        ContentDecoder[] contentDecoders;
        Validate.notNull(contentDecoder, "Content decoder cannot be null", new Object[0]);
        if (additionalContentDecoders == null || additionalContentDecoders.length == 0) {
            contentDecoders = new ContentDecoder[]{contentDecoder};
        } else {
            contentDecoders = new ContentDecoder[additionalContentDecoders.length + 1];
            contentDecoders[0] = contentDecoder;
            System.arraycopy(additionalContentDecoders, 0, contentDecoders, 1, additionalContentDecoders.length);
        }
        return contentDecoders;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentDecoder {
        GZIP,
        DEFLATE;

    }
}

