/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.mapper.ObjectMapper;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskAttachmentVersion;
import java.io.File;

public class TaskAttachment
extends ClientEntity<TaskAttachment> {
    @JsonReadOnly
    public String fileName;
    @JsonReadOnly
    public String description;
    @JsonReadOnly
    private String taskId;
    @JsonReadOnly
    private Long size;
    @JsonReadOnly
    private int currentVersion;
    @JsonReadOnly
    private TaskAttachmentVersion[] versions;
    @JsonReadOnly
    private String username;
    @JsonReadOnly
    private String userId;
    @JsonReadOnly
    private File file;

    public TaskAttachment() {
        this.path = "/taskAttachments/";
    }

    public TaskAttachment file(File file) {
        this.file = file;
        return this;
    }

    public TaskAttachment task(Task task) {
        this.taskId = task.getId();
        return this;
    }

    public TaskAttachment task(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public TaskAttachment description(String description) {
        this.description = description;
        return this;
    }

    @Override
    public TaskAttachment save() {
        if (this.description == null) {
            this.description = "";
        }
        RestAssured.given().contentType("multipart/form-data").multiPart("description", this.description).multiPart("modelID", this.taskId).multiPart("fileName", this.file.getName()).multiPart("file", this.file).expect().statusCode(200).when().post(this.path + "importAttachment", new Object[0]);
        return this;
    }

    public void addVersion(File file) {
        if (this.description == null) {
            this.description = "";
        }
        RestAssured.given().contentType("multipart/form-data").multiPart("description", this.description).multiPart("modelID", this.id).multiPart("file", file).expect().statusCode(200).when().post(this.path + this.id + "/newVersion", new Object[0]);
    }

    public byte[] download() {
        return RestAssured.get(this.path + this.taskId + "/" + this.fileName, new Object[0]).asByteArray();
    }

    protected TaskAttachment[] getAttachmentsForTask(String taskId) {
        return RestAssured.get(this.path + "forTask/" + taskId, new Object[0]).as(TaskAttachment[].class, ObjectMapper.GSON);
    }

    public TaskAttachmentVersion[] getVersions() {
        return RestAssured.get("taskAttachmentVersions/forAttachment/" + this.id, new Object[0]).as(TaskAttachmentVersion[].class, ObjectMapper.GSON);
    }
}

