/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.util;

import java.util.HashMap;
import java.util.Map;
import org.codehaus.jettison.json.JSONObject;

public class JSONCache {
    private static final ThreadLocal<JSONCache> userThreadLocal = new ThreadLocal();
    private Map<String, JSONObject> cache = new HashMap<String, JSONObject>();

    public static JSONCache getInstance() {
        JSONCache result = userThreadLocal.get();
        if (result == null) {
            result = new JSONCache();
            userThreadLocal.set(result);
        }
        return result;
    }

    public static void unbind() {
        userThreadLocal.remove();
    }

    public void cache(String id, JSONObject object) {
        this.cache.put(id, object);
    }

    public JSONObject get(String id) {
        return this.cache.get(id);
    }
}

