/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.webext.filters;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class RequestOverrideUserFilter
implements Filter {
    private static final Logger log = Logger.getLogger(RequestOverrideUserFilter.class);
    public static final String OVERRIDE_USERNAME_PARAM = "override.username";
    private String overrideUserName = null;

    public void init(FilterConfig config) throws ServletException {
        this.overrideUserName = config.getInitParameter(OVERRIDE_USERNAME_PARAM);
        Validate.notEmpty((String)this.overrideUserName, (String)"override.username parameter can not be empty");
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        log.debug((Object)("Setting request user to " + this.overrideUserName));
        request.setAttribute("currentUserName", (Object)this.overrideUserName);
        filterChain.doFilter(request, response);
    }
}

