#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2015, 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.*

import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;

import static com.urbancode.air.i18n.TranslateUtil.i18n;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;

import com.urbancode.air.XTrustProvider;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.http.client.HttpClient
import org.apache.http.client.*
import org.apache.http.client.methods.HttpGet;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;

import com.urbancode.air.plugin.jira.JiraFactory;

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();

def jiraUrl      = props['jiraUrl']
def jiraUser     = props['jiraUser']
def jiraPassword = props['jiraPassword']
def proxyHost    = props['proxyHost']
def proxyPort    = props['proxyPort']
def proxyUser    = props['proxyUser']
def proxyPass    = props['proxyPass']

try {
    println "URL:"+jiraUrl

    JiraFactory factory = new JiraFactory(jiraUrl, jiraUser, jiraPassword, proxyHost, proxyPort, proxyUser, proxyPass)

    def connectString = factory.testConnection();

    println "-------------------------------------------------------------------------------"
    println "Connection Successful"
    println "-------------------------------------------------------------------------------"
}
catch (e) {
    println "-------------------------------------------------------------------------------"
    println "Connection Failed"
    println "-------------------------------------------------------------------------------"
    throw new Exception("Error connecting to the JIRA Server <br/>"+e.getMessage());
}
