/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Release
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.jira;

import org.codehaus.jettison.json.JSONObject;
import com.urbancode.commons.webext.util.JSONUtilities;

public class JiraField {

    //**********************************************************************************************
    // CLASS
    //**********************************************************************************************

    //**********************************************************************************************
    // INSTANCE
    //**********************************************************************************************
    final private String name;
    final private String id;

    //----------------------------------------------------------------------------------------------
    public JiraField(String id, String name) {
        this.name = name
        this.id = id
    }

    //----------------------------------------------------------------------------------------------
    public JiraField(JSONObject json) {
        name = JSONUtilities.getStringFromJsonObject(json, "name");
        id = JSONUtilities.getStringFromJsonObject(json, "id");
    }

    //----------------------------------------------------------------------------------------------
    public String getName() {
        return name;
    }

    //----------------------------------------------------------------------------------------------
    public String getId() {
        return id;
    }
}
