/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

import java.util.Locale;
import org.apache.commons.httpclient.util.LangUtils;

public class AuthScope {
    public static final String ANY_HOST = null;
    public static final int ANY_PORT = -1;
    public static final String ANY_REALM = null;
    public static final String ANY_SCHEME = null;
    public static final AuthScope ANY = new AuthScope(ANY_HOST, -1, ANY_REALM, ANY_SCHEME);
    private String scheme = null;
    private String realm = null;
    private String host = null;
    private int port = -1;

    public AuthScope(String string, int n, String string2, String string3) {
        this.host = string == null ? ANY_HOST : string.toLowerCase(Locale.ENGLISH);
        this.port = n < 0 ? -1 : n;
        this.realm = string2 == null ? ANY_REALM : string2;
        this.scheme = string3 == null ? ANY_SCHEME : string3.toUpperCase(Locale.ENGLISH);
    }

    public AuthScope(String string, int n, String string2) {
        this(string, n, string2, ANY_SCHEME);
    }

    public AuthScope(String string, int n) {
        this(string, n, ANY_REALM, ANY_SCHEME);
    }

    public AuthScope(AuthScope authScope) {
        if (authScope == null) {
            throw new IllegalArgumentException("Scope may not be null");
        }
        this.host = authScope.getHost();
        this.port = authScope.getPort();
        this.realm = authScope.getRealm();
        this.scheme = authScope.getScheme();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    private static boolean paramsEqual(String string, String string2) {
        if (string == null) {
            return string == string2;
        }
        return string.equals(string2);
    }

    private static boolean paramsEqual(int n, int n2) {
        return n == n2;
    }

    public int match(AuthScope authScope) {
        int n = 0;
        if (AuthScope.paramsEqual(this.scheme, authScope.scheme)) {
            ++n;
        } else if (this.scheme != ANY_SCHEME && authScope.scheme != ANY_SCHEME) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.realm, authScope.realm)) {
            n += 2;
        } else if (this.realm != ANY_REALM && authScope.realm != ANY_REALM) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.port, authScope.port)) {
            n += 4;
        } else if (this.port != -1 && authScope.port != -1) {
            return -1;
        }
        if (AuthScope.paramsEqual(this.host, authScope.host)) {
            n += 8;
        } else if (this.host != ANY_HOST && authScope.host != ANY_HOST) {
            return -1;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof AuthScope)) {
            return super.equals(object);
        }
        AuthScope authScope = (AuthScope)object;
        return AuthScope.paramsEqual(this.host, authScope.host) && AuthScope.paramsEqual(this.port, authScope.port) && AuthScope.paramsEqual(this.realm, authScope.realm) && AuthScope.paramsEqual(this.scheme, authScope.scheme);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.scheme != null) {
            stringBuffer.append(this.scheme.toUpperCase(Locale.ENGLISH));
            stringBuffer.append(' ');
        }
        if (this.realm != null) {
            stringBuffer.append('\'');
            stringBuffer.append(this.realm);
            stringBuffer.append('\'');
        } else {
            stringBuffer.append("<any realm>");
        }
        if (this.host != null) {
            stringBuffer.append('@');
            stringBuffer.append(this.host);
            if (this.port >= 0) {
                stringBuffer.append(':');
                stringBuffer.append(this.port);
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 17;
        n = LangUtils.hashCode(n, this.host);
        n = LangUtils.hashCode(n, this.port);
        n = LangUtils.hashCode(n, this.realm);
        n = LangUtils.hashCode(n, this.scheme);
        return n;
    }
}

