/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.params;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.httpclient.params.HttpParamsFactory;

public class DefaultHttpParamsFactory
implements HttpParamsFactory {
    private HttpParams httpParams;

    @Override
    public synchronized HttpParams getDefaultParams() {
        if (this.httpParams == null) {
            this.httpParams = this.createParams();
        }
        return this.httpParams;
    }

    protected HttpParams createParams() {
        HttpClientParams httpClientParams = new HttpClientParams(null);
        httpClientParams.setParameter("http.useragent", "Jakarta Commons-HttpClient/3.1");
        httpClientParams.setVersion(HttpVersion.HTTP_1_1);
        httpClientParams.setConnectionManagerClass(SimpleHttpConnectionManager.class);
        httpClientParams.setCookiePolicy("default");
        httpClientParams.setHttpElementCharset("US-ASCII");
        httpClientParams.setContentCharset("ISO-8859-1");
        httpClientParams.setParameter("http.method.retry-handler", new DefaultHttpMethodRetryHandler());
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList("EEE, dd MMM yyyy HH:mm:ss zzz", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy", "EEE, dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MMM-yyyy HH-mm-ss z", "EEE, dd MMM yy HH:mm:ss z", "EEE dd-MMM-yyyy HH:mm:ss z", "EEE dd MMM yyyy HH:mm:ss z", "EEE dd-MMM-yyyy HH-mm-ss z", "EEE dd-MMM-yy HH:mm:ss z", "EEE dd MMM yy HH:mm:ss z", "EEE,dd-MMM-yy HH:mm:ss z", "EEE,dd-MMM-yyyy HH:mm:ss z", "EEE, dd-MM-yyyy HH:mm:ss z"));
        httpClientParams.setParameter("http.dateparser.patterns", arrayList);
        String string = null;
        try {
            string = System.getProperty("httpclient.useragent");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string != null) {
            httpClientParams.setParameter("http.useragent", string);
        }
        String string2 = null;
        try {
            string2 = System.getProperty("httpclient.authentication.preemptive");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 != null) {
            if ((string2 = string2.trim().toLowerCase(Locale.ENGLISH)).equals("true")) {
                httpClientParams.setParameter("http.authentication.preemptive", Boolean.TRUE);
            } else if (string2.equals("false")) {
                httpClientParams.setParameter("http.authentication.preemptive", Boolean.FALSE);
            }
        }
        String string3 = null;
        try {
            string3 = System.getProperty("apache.commons.httpclient.cookiespec");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string3 != null) {
            if ("COMPATIBILITY".equalsIgnoreCase(string3)) {
                httpClientParams.setCookiePolicy("compatibility");
            } else if ("NETSCAPE_DRAFT".equalsIgnoreCase(string3)) {
                httpClientParams.setCookiePolicy("netscape");
            } else if ("RFC2109".equalsIgnoreCase(string3)) {
                httpClientParams.setCookiePolicy("rfc2109");
            }
        }
        return httpClientParams;
    }
}

