/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        Socket socket = SSLSocketFactory.getDefault().createSocket(string, n, inetAddress, n2);
        SSLProtocolSocketFactory.verifyHostName(string, (SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        if (n3 == 0) {
            Socket socket = this.createSocket(string, n, inetAddress, n2);
            SSLProtocolSocketFactory.verifyHostName(string, (SSLSocket)socket);
            return socket;
        }
        Socket socket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", string, n, inetAddress, n2, n3);
        if (socket == null) {
            socket = ControllerThreadSocketFactory.createSocket(this, string, n, inetAddress, n2, n3);
        }
        SSLProtocolSocketFactory.verifyHostName(string, (SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        Socket socket = SSLSocketFactory.getDefault().createSocket(string, n);
        SSLProtocolSocketFactory.verifyHostName(string, (SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        Socket socket2 = ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, string, n, bl);
        SSLProtocolSocketFactory.verifyHostName(string, (SSLSocket)socket2);
        return socket2;
    }

    private static void verifyHostName(String string, SSLSocket sSLSocket) throws IOException {
        Certificate[] certificateArray;
        if (string == null) {
            throw new IllegalArgumentException("host to verify was null");
        }
        SSLSession sSLSession = sSLSocket.getSession();
        if (sSLSession == null) {
            certificateArray = sSLSocket.getInputStream();
            certificateArray.available();
            sSLSession = sSLSocket.getSession();
            if (sSLSession == null) {
                sSLSocket.startHandshake();
                sSLSession = sSLSocket.getSession();
            }
        }
        certificateArray = sSLSession.getPeerCertificates();
        SSLProtocolSocketFactory.verifyHostName(string.trim().toLowerCase(Locale.US), (X509Certificate)certificateArray[0]);
    }

    private static void verifyHostName(String string, X509Certificate x509Certificate) throws SSLException {
        String string2 = SSLProtocolSocketFactory.getCN(x509Certificate);
        String[] stringArray = SSLProtocolSocketFactory.getDNSSubjectAlts(x509Certificate);
        SSLProtocolSocketFactory.verifyHostName(string, string2.toLowerCase(Locale.US), stringArray);
    }

    private static String[] getDNSSubjectAlts(X509Certificate x509Certificate) {
        LinkedList<String> linkedList = new LinkedList<String>();
        Collection<List<?>> collection = null;
        try {
            collection = x509Certificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException certificateParsingException) {
            certificateParsingException.printStackTrace();
        }
        if (collection != null) {
            for (List list : collection) {
                int n = (Integer)list.get(0);
                if (n != 2) continue;
                String string = (String)list.get(1);
                linkedList.add(string);
            }
        }
        if (!linkedList.isEmpty()) {
            String[] stringArray = new String[linkedList.size()];
            linkedList.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    private static void verifyHostName(String string, String string2, String[] stringArray) throws SSLException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3 == null) continue;
            if (SSLProtocolSocketFactory.verifyHostName(string, string3 = string3.toLowerCase())) {
                return;
            }
            stringBuffer.append("/").append(string3);
        }
        if (string2 != null && SSLProtocolSocketFactory.verifyHostName(string, string2)) {
            return;
        }
        stringBuffer.append("/").append(string2);
        throw new SSLException("hostname in certificate didn't match: <" + string + "> != <" + stringBuffer + ">");
    }

    private static boolean verifyHostName(String string, String string2) {
        if (SSLProtocolSocketFactory.doWildCard(string2) && !SSLProtocolSocketFactory.isIPAddress(string)) {
            return SSLProtocolSocketFactory.matchesWildCard(string2, string);
        }
        return string.equalsIgnoreCase(string2);
    }

    private static boolean doWildCard(String string) {
        String[] stringArray = string.split("\\.");
        return stringArray.length >= 3 && stringArray[0].endsWith("*") && SSLProtocolSocketFactory.acceptableCountryWildcard(string) && !SSLProtocolSocketFactory.isIPAddress(string);
    }

    private static boolean isIPAddress(String string) {
        return string != null && (IPV4_PATTERN.matcher(string).matches() || IPV6_STD_PATTERN.matcher(string).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(string).matches());
    }

    private static boolean acceptableCountryWildcard(String string) {
        String[] stringArray = string.split("\\.");
        if (stringArray.length > 3 || stringArray[stringArray.length - 1].length() != 2) {
            return true;
        }
        String string2 = stringArray[stringArray.length - 2];
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, string2) < 0;
    }

    private static boolean matchesWildCard(String string, String string2) {
        String[] stringArray = string.split("\\.");
        boolean bl = false;
        String string3 = stringArray[0];
        if (string3.length() > 1) {
            String string4 = string3.substring(0, string3.length() - 1);
            String string5 = string.substring(string3.length());
            String string6 = string2.substring(string4.length());
            bl = string2.startsWith(string4) && string6.endsWith(string5);
        } else {
            bl = string2.endsWith(string.substring(1));
        }
        if (bl) {
            bl = SSLProtocolSocketFactory.countDots(string2) == SSLProtocolSocketFactory.countDots(string);
        }
        return bl;
    }

    private static int countDots(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '.') continue;
            ++n;
        }
        return n;
    }

    private static String getCN(X509Certificate x509Certificate) {
        String string = x509Certificate.getSubjectX500Principal().toString();
        return SSLProtocolSocketFactory.getCN(string);
    }

    private static String getCN(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 3 || !string2.substring(0, 3).equalsIgnoreCase("CN=")) continue;
            return string2.substring(3);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

