/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.model;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.jibx.binding.model.BindingElement;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.IncludeElement;
import org.jibx.binding.model.NamespaceElement;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.JiBXException;
import org.jibx.util.InsertionOrderedMap;
import org.jibx.util.InsertionOrderedSet;
import org.jibx.util.LazyList;

public class BindingOrganizer {
    private final boolean m_forceClasses;
    private final boolean m_trackSource;
    private final boolean m_addConstructors;
    private final boolean m_inBinding;
    private final boolean m_outBinding;
    private final boolean m_useDefault;
    private final boolean m_elementDefault;
    private final InsertionOrderedSet m_referencedNamespaces;
    private final InsertionOrderedMap m_nsPrefixMap;
    private final InsertionOrderedMap m_uriBindingMap;
    private final LazyList m_formats;
    private String m_defaultUri;
    private boolean m_finished;
    static /* synthetic */ Class class$org$jibx$binding$model$BindingElement;

    public BindingOrganizer(boolean force, boolean track, boolean addcon, boolean in, boolean out, boolean dfltns, boolean elmtdflt) {
        this.m_elementDefault = elmtdflt;
        this.m_useDefault = dfltns;
        this.m_forceClasses = force;
        this.m_trackSource = track;
        this.m_addConstructors = addcon;
        this.m_inBinding = in;
        this.m_outBinding = out;
        this.m_referencedNamespaces = new InsertionOrderedSet();
        this.m_nsPrefixMap = new InsertionOrderedMap();
        this.m_uriBindingMap = new InsertionOrderedMap();
        this.m_formats = new LazyList();
    }

    public BindingHolder findBinding(String uri) {
        BindingHolder hold = (BindingHolder)this.m_uriBindingMap.get(uri);
        if (hold == null) {
            hold = new BindingHolder(uri, this.m_elementDefault, this);
            this.m_uriBindingMap.put(uri, hold);
            BindingElement binding = hold.getBinding();
            binding.setForceClasses(this.m_forceClasses);
            binding.setTrackSource(this.m_trackSource);
            binding.setAddConstructors(this.m_addConstructors);
            binding.setInBinding(this.m_inBinding);
            binding.setOutBinding(this.m_outBinding);
            if (this.m_useDefault && this.m_defaultUri == null) {
                this.m_defaultUri = uri;
            }
        }
        return hold;
    }

    public static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    private void checkModifiable() {
        if (this.m_finished) {
            throw new IllegalStateException("Internal error - attempt to modify bindings after finalized");
        }
    }

    void addNamespaceReference(String uri) {
        this.checkModifiable();
        if (this.m_referencedNamespaces.add(uri)) {
            this.m_nsPrefixMap.put(uri, "ns" + this.m_nsPrefixMap.size());
        }
    }

    public void addFormat(FormatElement format) {
        this.checkModifiable();
        this.m_formats.add(format);
    }

    public Iterator iterateBindings() {
        return this.m_uriBindingMap.values().iterator();
    }

    public BindingHolder getBinding(String uri) {
        return (BindingHolder)this.m_uriBindingMap.get(uri);
    }

    public ArrayList getNamespaces() {
        return this.m_uriBindingMap.keyList();
    }

    private void addNamespaceDeclarations(String[] adduris, BindingElement binding) {
        int offset = -1;
        int nsnum = this.m_uriBindingMap.size();
        for (int i = 0; i < adduris.length; ++i) {
            String adduri = adduris[i];
            if (this.m_uriBindingMap.containsKey(adduri)) continue;
            ArrayList childs = binding.topChildren();
            if (offset < 0) {
                while (++offset < childs.size() && childs.get(offset) instanceof NamespaceElement) {
                }
            }
            NamespaceElement ns = new NamespaceElement();
            ns.setDefaultName("none");
            ns.setUri(adduri);
            ns.setPrefix("ns" + ++nsnum);
            childs.add(offset++, ns);
        }
    }

    private static boolean isAsciiAlpha(char chr) {
        return chr >= 'a' && chr <= 'z' || chr >= 'A' && chr <= 'Z';
    }

    private static boolean isAsciiNum(char chr) {
        return chr >= '0' && chr <= '9';
    }

    private static boolean isAsciiAlphaNum(char chr) {
        return BindingOrganizer.isAsciiAlpha(chr) || BindingOrganizer.isAsciiNum(chr);
    }

    public BindingHolder configureFiles(String name, String[] adduris, String pack) {
        int i;
        BindingElement root;
        BindingHolder rhold;
        ArrayList uris;
        this.checkModifiable();
        if (this.m_uriBindingMap.size() > 1) {
            uris = new ArrayList();
            Iterator iter = this.m_uriBindingMap.keyList().iterator();
            while (iter.hasNext()) {
                String uri = (String)iter.next();
                rhold = (BindingHolder)this.m_uriBindingMap.get(uri);
                if (rhold.getMappingCount() > 0) {
                    uris.add(uri);
                    continue;
                }
                this.m_uriBindingMap.put(uri, (Object)null);
            }
        } else {
            uris = this.m_uriBindingMap.keyList();
        }
        ArrayList<IncludeElement> includes = Collections.EMPTY_LIST;
        if (uris.size() == 1) {
            rhold = (BindingHolder)this.m_uriBindingMap.get(uris.get(0));
            root = rhold.getBinding();
        } else {
            rhold = this.findBinding(null);
            root = rhold.getBinding();
            includes = new ArrayList<IncludeElement>();
            HashSet<String> nameset = new HashSet<String>();
            for (i = 0; i < uris.size(); ++i) {
                String bindname;
                String uri = (String)uris.get(i);
                BindingHolder holder = (BindingHolder)this.m_uriBindingMap.get(uri);
                if (holder == rhold) continue;
                String raw = holder.getNamespace();
                if (raw == null) {
                    bindname = "nonamespaceBinding";
                } else {
                    int split = (raw = raw.replace('\\', '/')).indexOf("://");
                    if (split >= 0) {
                        raw = raw.substring(split + 3);
                    }
                    while (raw.endsWith("/")) {
                        raw = raw.substring(0, raw.length() - 1);
                    }
                    split = raw.indexOf(47);
                    if (split > 0 && raw.substring(0, split).indexOf(46) > 0) {
                        raw = raw.substring(split + 1);
                    }
                    StringBuffer buff = new StringBuffer();
                    int index = 0;
                    char chr = raw.charAt(0);
                    if (BindingOrganizer.isAsciiAlpha(chr)) {
                        buff.append(chr);
                        index = 1;
                    } else {
                        buff.append('_');
                    }
                    boolean toupper = false;
                    while (index < raw.length()) {
                        if (BindingOrganizer.isAsciiAlphaNum(chr = raw.charAt(index++))) {
                            if (toupper) {
                                chr = Character.toUpperCase(chr);
                                toupper = false;
                            }
                            buff.append(chr);
                            continue;
                        }
                        if (chr == '.') {
                            toupper = true;
                            continue;
                        }
                        if (chr != ':' && chr != '/') continue;
                        buff.append('_');
                    }
                    buff.append("Binding");
                    bindname = buff.toString();
                }
                String uname = bindname.toLowerCase();
                int pass = 0;
                while (nameset.contains(uname)) {
                    bindname = bindname + pass;
                    uname = bindname.toLowerCase();
                }
                nameset.add(uname);
                holder.setBindingName(uname);
                holder.setFileName(bindname + ".xml");
                boolean dfltns = BindingOrganizer.isEqual(this.m_defaultUri, holder.getNamespace());
                holder.finish(Collections.EMPTY_LIST, Collections.EMPTY_LIST, dfltns, this.m_referencedNamespaces, this.m_nsPrefixMap);
                IncludeElement include = new IncludeElement();
                include.setIncludePath(holder.getFileName());
                includes.add(include);
            }
        }
        ArrayList nsuris = this.m_referencedNamespaces.asList();
        for (i = 0; i < nsuris.size(); ++i) {
            rhold.addNamespaceDependency((String)nsuris.get(i));
        }
        for (i = 0; i < adduris.length; ++i) {
            rhold.addNamespaceDependency(adduris[i]);
        }
        boolean dfltns = BindingOrganizer.isEqual(this.m_defaultUri, rhold.getNamespace());
        rhold.finish(this.m_formats, includes, dfltns, Collections.EMPTY_SET, this.m_nsPrefixMap);
        rhold.setFileName(name);
        int split = name.lastIndexOf(46);
        if (split > 0) {
            root.setName(name.substring(0, split));
        } else {
            root.setName(name);
        }
        this.m_finished = true;
        root.setTargetPackage(pack);
        return rhold;
    }

    public void writeBindings(File dir) throws JiBXException, IOException {
        IBindingFactory fact = BindingDirectory.getFactory((String)"normal", (Class)(class$org$jibx$binding$model$BindingElement == null ? (class$org$jibx$binding$model$BindingElement = BindingOrganizer.class$("org.jibx.binding.model.BindingElement")) : class$org$jibx$binding$model$BindingElement));
        IMarshallingContext ictx = fact.createMarshallingContext();
        ictx.setIndent(2);
        ArrayList uris = this.getNamespaces();
        for (int i = 0; i < uris.size(); ++i) {
            String uri = (String)uris.get(i);
            BindingHolder holder = (BindingHolder)this.m_uriBindingMap.get(uri);
            if (holder == null) continue;
            File file = new File(dir, holder.getFileName());
            ictx.setOutput((OutputStream)new FileOutputStream(file), null);
            ((IMarshallable)holder.getBinding()).marshal(ictx);
            ictx.getXmlWriter().flush();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

