/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.format;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import javax.activation.DataSource;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromDataSource;
import org.apache.axiom.om.ds.WrappedTextNodeOMDataSourceFromReader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.BuilderUtil;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.format.DataSourceMessageBuilder;
import org.apache.axis2.format.TextMessageBuilder;
import org.apache.axis2.transport.base.BaseConstants;
import org.apache.axis2.transport.base.BaseUtils;

public class PlainTextBuilder
implements TextMessageBuilder,
DataSourceMessageBuilder {
    private static QName getWrapperQName(MessageContext msgContext) {
        Parameter wrapperParam;
        QName wrapperQName = BaseConstants.DEFAULT_TEXT_WRAPPER;
        if (msgContext.getAxisService() != null && (wrapperParam = msgContext.getAxisService().getParameter("Wrapper")) != null) {
            wrapperQName = BaseUtils.getQNameFromString(wrapperParam.getValue());
        }
        return wrapperQName;
    }

    public OMElement processDocument(InputStream inputStream, String contentType, MessageContext msgContext) throws AxisFault {
        InputStreamReader reader;
        OMFactory factory = OMAbstractFactory.getOMFactory();
        String charSetEnc = BuilderUtil.getCharSetEncoding((String)contentType);
        QName wrapperQName = PlainTextBuilder.getWrapperQName(msgContext);
        try {
            reader = new InputStreamReader(inputStream, charSetEnc);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AxisFault("Unsupported encoding: " + charSetEnc, (Throwable)ex);
        }
        return factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromReader(wrapperQName, (Reader)reader), wrapperQName);
    }

    public OMElement processDocument(Reader reader, String contentType, MessageContext msgContext) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        QName wrapperQName = PlainTextBuilder.getWrapperQName(msgContext);
        return factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromReader(wrapperQName, reader), wrapperQName);
    }

    public OMElement processDocument(String content, String contentType, MessageContext msgContext) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        OMElement wrapper = factory.createOMElement(PlainTextBuilder.getWrapperQName(msgContext), null);
        factory.createOMText((OMContainer)wrapper, content);
        return wrapper;
    }

    public OMElement processDocument(DataSource dataSource, String contentType, MessageContext msgContext) throws AxisFault {
        OMFactory factory = OMAbstractFactory.getOMFactory();
        Charset cs = Charset.forName(BuilderUtil.getCharSetEncoding((String)contentType));
        QName wrapperQName = PlainTextBuilder.getWrapperQName(msgContext);
        return factory.createOMElement((OMDataSource)new WrappedTextNodeOMDataSourceFromDataSource(wrapperQName, dataSource, cs), wrapperQName);
    }
}

