/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.description;

import com.ibm.wsdl.util.xml.DOM2Writer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingMessage;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.WSDL20DefaultValueHolder;
import org.apache.axis2.description.WSDLToAxisServiceBuilder;
import org.apache.axis2.namespace.Constants;
import org.apache.axis2.wsdl.HTTPHeaderMessage;
import org.apache.axis2.wsdl.SOAPHeaderMessage;
import org.apache.axis2.wsdl.SOAPModuleMessage;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.WSDLSource;
import org.apache.woden.XMLElement;
import org.apache.woden.resolver.URIResolver;
import org.apache.woden.schema.Schema;
import org.apache.woden.types.NamespaceDeclaration;
import org.apache.woden.types.QNameTokenUnion;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.BindingFault;
import org.apache.woden.wsdl20.BindingFaultReference;
import org.apache.woden.wsdl20.BindingMessageReference;
import org.apache.woden.wsdl20.BindingOperation;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.Endpoint;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.InterfaceFault;
import org.apache.woden.wsdl20.InterfaceFaultReference;
import org.apache.woden.wsdl20.InterfaceMessageReference;
import org.apache.woden.wsdl20.InterfaceOperation;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.enumeration.MessageLabel;
import org.apache.woden.wsdl20.extensions.InterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.http.HTTPHeader;
import org.apache.woden.wsdl20.extensions.http.HTTPHeaderElement;
import org.apache.woden.wsdl20.extensions.http.HTTPLocation;
import org.apache.woden.wsdl20.extensions.rpc.Argument;
import org.apache.woden.wsdl20.extensions.rpc.RPCInterfaceOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingFaultReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingMessageReferenceExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPBindingOperationExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPEndpointExtensions;
import org.apache.woden.wsdl20.extensions.soap.SOAPHeaderBlock;
import org.apache.woden.wsdl20.extensions.soap.SOAPModule;
import org.apache.woden.wsdl20.xml.BindingFaultElement;
import org.apache.woden.wsdl20.xml.BindingOperationElement;
import org.apache.woden.wsdl20.xml.DescriptionElement;
import org.apache.woden.wsdl20.xml.DocumentableElement;
import org.apache.woden.wsdl20.xml.DocumentationElement;
import org.apache.woden.wsdl20.xml.ImportElement;
import org.apache.woden.wsdl20.xml.InterfaceFaultElement;
import org.apache.woden.wsdl20.xml.InterfaceMessageReferenceElement;
import org.apache.woden.wsdl20.xml.TypesElement;
import org.apache.woden.xml.XMLAttr;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSDL20ToAxisServiceBuilder
extends WSDLToAxisServiceBuilder {
    protected static final Log log = LogFactory.getLog(WSDL20ToAxisServiceBuilder.class);
    protected Description description;
    private String wsdlURI;
    protected String interfaceName;
    private String savedTargetNamespace;
    private NamespaceDeclaration[] namespacemap;
    private List<QName> operationNames = new ArrayList<QName>();
    private NamespaceMap stringBasedNamespaceMap;
    private boolean setupComplete = false;
    private Service wsdlService;
    private boolean isAllPorts;
    private URIResolver customWSDLResolver;
    private Map processedBindings;

    public WSDL20ToAxisServiceBuilder(InputStream in, QName serviceName, String interfaceName) {
        this.in = in;
        this.serviceName = serviceName;
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, String name, String interfaceName) throws WSDLException {
        Description description;
        String fullPath = wsdlUri;
        if (!wsdlUri.startsWith("http://")) {
            File file = new File(wsdlUri);
            fullPath = file.getAbsolutePath();
        }
        this.setBaseUri(fullPath);
        try {
            description = this.readInTheWSDLFile(fullPath);
        }
        catch (AxisFault axisFault) {
            throw new WSDLException("ERROR", "Exception occured while reading WSDL 2.0 doc", (Throwable)axisFault);
        }
        DescriptionElement descriptionElement = description.toElement();
        this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
        this.namespacemap = descriptionElement.getDeclaredNamespaces();
        this.description = description;
        this.serviceName = null;
        if (name != null) {
            this.serviceName = new QName(descriptionElement.getTargetNamespace().toString(), name);
        }
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, String name, String interfaceName, boolean isAllPorts) throws WSDLException {
        this(wsdlUri, name, interfaceName);
        this.isAllPorts = isAllPorts;
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, QName serviceName) {
        super(null, serviceName);
        this.wsdlURI = wsdlUri;
    }

    public WSDL20ToAxisServiceBuilder(String wsdlUri, AxisService service) {
        super(null, service);
        this.wsdlURI = wsdlUri;
    }

    public WSDL20ToAxisServiceBuilder(Description descriptionComp, QName wsdlServiceName, String interfaceName) {
        DescriptionElement descriptionElement = descriptionComp.toElement();
        this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
        this.namespacemap = descriptionElement.getDeclaredNamespaces();
        this.description = descriptionElement.toComponent();
        this.serviceName = null;
        if (wsdlServiceName != null) {
            this.serviceName = wsdlServiceName;
        }
        this.interfaceName = interfaceName;
        this.axisService = new AxisService();
        this.setPolicyRegistryFromService(this.axisService);
    }

    public boolean isAllPorts() {
        return this.isAllPorts;
    }

    public void setAllPorts(boolean allPorts) {
        this.isAllPorts = allPorts;
    }

    public void setCustomWSDLResolver(URIResolver customResolver) {
        this.customWSDLResolver = customResolver;
    }

    @Override
    public AxisService populateService() throws AxisFault {
        try {
            this.setup();
            Parameter wsdlDescriptionParamter = new Parameter();
            wsdlDescriptionParamter.setName("WSDL20Description");
            wsdlDescriptionParamter.setValue(this.description);
            this.axisService.addParameter(wsdlDescriptionParamter);
            if (this.isCodegen) {
                this.axisService.addParameter("isCodegen", Boolean.TRUE);
            }
            if (this.description == null) {
                return null;
            }
            this.axisService.setTargetNamespace(this.savedTargetNamespace);
            this.addDocumentation(this.axisService, (DocumentableElement)this.description.toElement());
            this.axisService.setNamespaceMap(this.stringBasedNamespaceMap);
            DescriptionElement descriptionElement = this.description.toElement();
            this.processTypes(descriptionElement);
            this.processService();
            return this.axisService;
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    private void processTypes(DescriptionElement descriptionElement) {
        int i;
        TypesElement typesElement = descriptionElement.getTypesElement();
        if (typesElement != null) {
            Schema[] schemas = typesElement.getSchemas();
            for (i = 0; i < schemas.length; ++i) {
                XmlSchema schemaDefinition = schemas[i].getSchemaDefinition();
                if (schemaDefinition == null || "http://www.w3.org/2001/XMLSchema".equals(schemaDefinition.getTargetNamespace())) continue;
                this.axisService.addSchema(schemaDefinition);
            }
        }
        ImportElement[] importElements = descriptionElement.getImportElements();
        for (i = 0; i < importElements.length; ++i) {
            DescriptionElement descElem = importElements[i].getDescriptionElement();
            this.processTypes(descElem);
        }
    }

    private void processEndpoints(Interface serviceInterface) throws AxisFault {
        Endpoint[] endpoints = this.wsdlService.getEndpoints();
        if (endpoints.length == 0) {
            throw new AxisFault("No endpoints found in the WSDL");
        }
        this.processedBindings = new HashMap();
        Endpoint endpoint = null;
        if (this.interfaceName != null) {
            for (int i = 0; i < endpoints.length; ++i) {
                if (!this.interfaceName.equals(endpoints[i].getName().toString())) continue;
                endpoint = endpoints[i];
                break;
            }
            if (endpoint == null) {
                throw new AxisFault("No endpoint found for the given name :" + this.interfaceName);
            }
            this.axisService.addEndpoint(endpoint.getName().toString(), this.processEndpoint(endpoint, serviceInterface));
        } else if (this.isCodegen && !this.isAllPorts) {
            Endpoint soap11Endpoint = null;
            for (int i = 0; i < endpoints.length; ++i) {
                SOAPBindingExtensions soapBindingExtensions;
                Binding binding = endpoints[i].getBinding();
                if (!"http://www.w3.org/ns/wsdl/soap".equals(binding.getType().toString())) continue;
                try {
                    soapBindingExtensions = (SOAPBindingExtensions)binding.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("Soap Binding Extention not found");
                }
                if (!"1.1".equals(soapBindingExtensions.getSoapVersion())) {
                    endpoint = endpoints[i];
                    break;
                }
                if (soap11Endpoint != null) continue;
                soap11Endpoint = endpoints[i];
            }
            if (endpoint == null) {
                endpoint = endpoints[0];
            }
            this.axisService.addEndpoint(endpoint.getName().toString(), this.processEndpoint(endpoint, serviceInterface));
        } else {
            for (int i = 0; i < endpoints.length; ++i) {
                this.axisService.addEndpoint(endpoints[i].getName().toString(), this.processEndpoint(endpoints[i], serviceInterface));
            }
        }
        if (endpoint == null && endpoints.length > 0) {
            endpoint = endpoints[0];
        }
        if (endpoint != null) {
            this.axisService.setEndpointName(endpoint.getName().toString());
            this.axisService.setBindingName(endpoint.getBinding().getName().getLocalPart());
            this.axisService.setEndpointURL(endpoint.getAddress().toString());
        }
    }

    private void processService() throws AxisFault {
        Service[] services = this.description.getServices();
        if (services.length == 0) {
            throw new AxisFault("No wsdlService found in the WSDL");
        }
        if (this.serviceName != null) {
            for (int i = 0; i < services.length; ++i) {
                if (!this.serviceName.equals(services[i].getName())) continue;
                this.wsdlService = services[i];
                break;
            }
            if (this.wsdlService == null) {
                throw new AxisFault("Service with the specified name not found in the WSDL : " + this.serviceName.getLocalPart());
            }
        } else {
            this.wsdlService = services[0];
        }
        this.axisService.setName(this.wsdlService.getName().getLocalPart());
        Interface serviceInterface = this.wsdlService.getInterface();
        this.axisService.addParameter(new Parameter("interface", serviceInterface.getName().getLocalPart()));
        this.processInterface(serviceInterface);
        if (this.isCodegen) {
            this.axisService.setOperationsNameList(this.operationNames);
        }
        this.processEndpoints(serviceInterface);
    }

    private AxisEndpoint processEndpoint(Endpoint endpoint, Interface serviceInterface) throws AxisFault {
        AxisEndpoint axisEndpoint = new AxisEndpoint();
        axisEndpoint.setParent(this.axisService);
        axisEndpoint.setName(endpoint.getName().toString());
        this.setEndpointURL(axisEndpoint, endpoint.getAddress().toString());
        Binding binding = endpoint.getBinding();
        AxisBinding axisBinding = this.processedBindings.containsKey(binding.getName()) ? (AxisBinding)this.processedBindings.get(binding.getName()) : this.processBinding(binding, serviceInterface);
        axisEndpoint.setBinding(axisBinding);
        String bindingType = binding.getType().toString();
        if (bindingType.equals("http://www.w3.org/ns/wsdl/soap")) {
            this.processSOAPBindingEndpointExtensions(endpoint, axisEndpoint);
        } else if (bindingType.equals("http://www.w3.org/ns/wsdl/http")) {
            this.processHTTPBindingEndpointExtensions(endpoint, axisEndpoint);
        }
        this.addDocumentation(axisEndpoint, (DocumentableElement)endpoint.toElement());
        return axisEndpoint;
    }

    private void processSOAPBindingEndpointExtensions(Endpoint endpoint, AxisEndpoint axisEndpoint) throws AxisFault {
        SOAPEndpointExtensions soapEndpointExtensions;
        try {
            soapEndpointExtensions = (SOAPEndpointExtensions)endpoint.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("SOAP Binding Endpoint Extension not found");
        }
        if (soapEndpointExtensions != null) {
            axisEndpoint.setProperty("whttp:authenticationType", soapEndpointExtensions.getHttpAuthenticationScheme());
            axisEndpoint.setProperty("whttp:authenticationRealm", soapEndpointExtensions.getHttpAuthenticationRealm());
        }
    }

    private void processHTTPBindingEndpointExtensions(Endpoint endpoint, AxisEndpoint axisEndpoint) throws AxisFault {
        HTTPEndpointExtensions httpEndpointExtensions;
        try {
            httpEndpointExtensions = (HTTPEndpointExtensions)endpoint.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/http"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("HTTP Binding Endpoint Extension not found");
        }
        if (httpEndpointExtensions != null) {
            axisEndpoint.setProperty("whttp:authenticationType", httpEndpointExtensions.getHttpAuthenticationScheme());
            axisEndpoint.setProperty("whttp:authenticationRealm", httpEndpointExtensions.getHttpAuthenticationRealm());
        }
    }

    protected void setup() throws AxisFault, WSDLException {
        if (this.setupComplete) {
            return;
        }
        try {
            if (this.description == null) {
                DescriptionElement descriptionElement;
                Description description;
                if (this.wsdlURI != null && !"".equals(this.wsdlURI)) {
                    description = this.readInTheWSDLFile(this.wsdlURI);
                    descriptionElement = description.toElement();
                } else if (this.in != null) {
                    description = this.readInTheWSDLFile(this.in);
                    descriptionElement = description.toElement();
                } else {
                    throw new AxisFault("No resources found to read the wsdl");
                }
                this.savedTargetNamespace = descriptionElement.getTargetNamespace().toString();
                this.namespacemap = descriptionElement.getDeclaredNamespaces();
                this.description = description;
            }
            this.stringBasedNamespaceMap = new NamespaceMap();
            for (int i = 0; i < this.namespacemap.length; ++i) {
                NamespaceDeclaration namespaceDeclaration = this.namespacemap[i];
                this.stringBasedNamespaceMap.put((Object)namespaceDeclaration.getPrefix(), (Object)namespaceDeclaration.getNamespaceURI().toString());
            }
            DescriptionElement descriptionElement = this.description.toElement();
            this.createNamespaceMap(descriptionElement);
            this.setupComplete = true;
        }
        catch (AxisFault e) {
            throw e;
        }
        catch (WSDLException e) {
            throw e;
        }
        catch (Exception e) {
            throw AxisFault.makeFault(e);
        }
    }

    private void createNamespaceMap(DescriptionElement descriptionElement) {
        ImportElement[] importElements = descriptionElement.getImportElements();
        for (int i = 0; i < importElements.length; ++i) {
            DescriptionElement descElem = importElements[i].getDescriptionElement();
            NamespaceDeclaration[] namespaceDeclarations = descElem.getDeclaredNamespaces();
            for (int j = 0; j < namespaceDeclarations.length; ++j) {
                NamespaceDeclaration importedNamespaceDeclaration = namespaceDeclarations[j];
                if (this.stringBasedNamespaceMap.containsKey((Object)importedNamespaceDeclaration.getPrefix())) continue;
                this.stringBasedNamespaceMap.put((Object)importedNamespaceDeclaration.getPrefix(), (Object)importedNamespaceDeclaration.getNamespaceURI().toString());
            }
            this.createNamespaceMap(descElem);
        }
    }

    private AxisBinding processBinding(Binding binding, Interface serviceInterface) throws AxisFault {
        AxisBinding axisBinding = new AxisBinding();
        axisBinding.setName(binding.getName());
        String bindingType = binding.getType().toString();
        axisBinding.setType(bindingType);
        if (bindingType.equals("http://www.w3.org/ns/wsdl/soap")) {
            this.processSOAPBindingExtention(binding, axisBinding, serviceInterface);
        } else if (bindingType.equals("http://www.w3.org/ns/wsdl/http")) {
            this.processHTTPBindingExtention(binding, axisBinding, serviceInterface);
        }
        this.processedBindings.put(binding.getName(), axisBinding);
        this.addDocumentation(axisBinding, (DocumentableElement)binding.toElement());
        return axisBinding;
    }

    private void processSOAPBindingExtention(Binding binding, AxisBinding axisBinding, Interface serviceInterface) throws AxisFault {
        URI soapMepDefault;
        SOAPBindingExtensions soapBindingExtensions;
        TreeMap<String, AxisOperation> httpLocationTable = new TreeMap<String, AxisOperation>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return -1 * ((Comparable)o1).compareTo(o2);
            }
        });
        try {
            soapBindingExtensions = (SOAPBindingExtensions)binding.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("Soap Binding Extention not found");
        }
        String soapVersion = soapBindingExtensions.getSoapVersion();
        if (soapVersion != null) {
            if (soapVersion.equals("1.1")) {
                axisBinding.setProperty("wsoap:version", "http://schemas.xmlsoap.org/soap/envelope/");
            } else {
                axisBinding.setProperty("wsoap:version", "http://www.w3.org/2003/05/soap-envelope");
            }
        } else {
            axisBinding.setProperty("wsoap:version", WSDL20DefaultValueHolder.getDefaultValue("wsoap:version"));
        }
        URI soapUnderlyingProtocol = soapBindingExtensions.getSoapUnderlyingProtocol();
        if (soapUnderlyingProtocol != null) {
            axisBinding.setProperty("wsoap:protocol", soapUnderlyingProtocol.toString());
        }
        if ((soapMepDefault = soapBindingExtensions.getSoapMepDefault()) != null) {
            axisBinding.setProperty("wsoap:mep", soapMepDefault.toString());
        }
        axisBinding.setProperty("whttp:contentEncoding", soapBindingExtensions.getHttpContentEncodingDefault());
        axisBinding.setProperty("wsoap:module", this.createSoapModules(soapBindingExtensions.getSoapModules()));
        axisBinding.setProperty("whttp:queryParameterSeparator", soapBindingExtensions.getHttpQueryParameterSeparatorDefault());
        BindingFault[] bindingFaults = binding.getBindingFaults();
        for (int i = 0; i < bindingFaults.length; ++i) {
            SOAPBindingFaultExtensions soapBindingFaultExtensions;
            BindingFault bindingFault = bindingFaults[i];
            InterfaceFault interfaceFault = serviceInterface.getFromAllInterfaceFaults(((BindingFaultElement)bindingFault).getRef());
            AxisBindingMessage axisBindingFault = new AxisBindingMessage();
            axisBindingFault.setFault(true);
            axisBindingFault.setName(interfaceFault.getName().getLocalPart());
            axisBindingFault.setParent(axisBinding);
            this.addDocumentation(axisBindingFault, (DocumentableElement)interfaceFault.toElement());
            try {
                soapBindingFaultExtensions = (SOAPBindingFaultExtensions)bindingFault.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Soap Binding Extention not found");
            }
            axisBindingFault.setProperty("whttp:header", this.createHttpHeaders(soapBindingFaultExtensions.getHttpHeaders()));
            axisBindingFault.setProperty("whttp:contentEncoding", soapBindingFaultExtensions.getHttpContentEncoding());
            axisBindingFault.setProperty("wsoap:code", soapBindingFaultExtensions.getSoapFaultCode());
            axisBindingFault.setProperty("wsoap:subcodes", soapBindingFaultExtensions.getSoapFaultSubcodes());
            axisBindingFault.setProperty("wsoap:header", this.createSoapHeaders(soapBindingFaultExtensions.getSoapHeaders()));
            axisBindingFault.setProperty("wsoap:module", this.createSoapModules(soapBindingFaultExtensions.getSoapModules()));
            axisBinding.addFault(axisBindingFault);
        }
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        for (int i = 0; i < bindingOperations.length; ++i) {
            SOAPBindingOperationExtensions soapBindingOperationExtensions;
            BindingOperation bindingOperation = bindingOperations[i];
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            InterfaceOperation interfaceOperation = serviceInterface.getFromAllInterfaceOperations(((BindingOperationElement)bindingOperation).getRef());
            AxisOperation axisOperation = this.axisService.getOperation(interfaceOperation.getName());
            axisBindingOperation.setAxisOperation(axisOperation);
            axisBindingOperation.setParent(axisBinding);
            axisBindingOperation.setName(axisOperation.getName());
            this.addDocumentation(axisBindingOperation, (DocumentableElement)bindingOperation.toElement());
            try {
                soapBindingOperationExtensions = (SOAPBindingOperationExtensions)bindingOperation.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("Soap Binding Extention not found");
            }
            URI soapAction = soapBindingOperationExtensions.getSoapAction();
            if (soapAction != null && !"\"\"".equals(soapAction.toString())) {
                axisBindingOperation.setProperty("wsoap:action", soapAction.toString());
            }
            axisBindingOperation.setProperty("wsoap:module", this.createSoapModules(soapBindingOperationExtensions.getSoapModules()));
            URI soapMep = soapBindingOperationExtensions.getSoapMep();
            if (soapMep != null) {
                axisBindingOperation.setProperty("wsoap:mep", soapMep.toString());
            }
            HTTPLocation httpLocation = soapBindingOperationExtensions.getHttpLocation();
            String httpLocationString = null;
            if (httpLocation != null) {
                String httpLocationTemplete = httpLocation.getOriginalLocation();
                axisBindingOperation.setProperty("whttp:location", httpLocationTemplete);
                httpLocationString = WSDLUtil.getConstantFromHTTPLocation(httpLocationTemplete, "POST");
            }
            if (httpLocationString != null) {
                httpLocationTable.put(httpLocationString, axisOperation);
            }
            axisBindingOperation.setProperty("whttp:contentEncoding", soapBindingOperationExtensions.getHttpContentEncodingDefault());
            axisBindingOperation.setProperty("whttp:queryParameterSeparator", soapBindingOperationExtensions.getHttpQueryParameterSeparator());
            BindingMessageReference[] bindingMessageReferences = bindingOperation.getBindingMessageReferences();
            for (int j = 0; j < bindingMessageReferences.length; ++j) {
                SOAPBindingMessageReferenceExtensions soapBindingMessageReferenceExtensions;
                BindingMessageReference bindingMessageReference = bindingMessageReferences[j];
                AxisBindingMessage axisBindingMessage = new AxisBindingMessage();
                axisBindingMessage.setParent(axisBindingOperation);
                this.addDocumentation(axisBindingMessage, (DocumentableElement)bindingMessageReference.toElement());
                AxisMessage axisMessage = axisOperation.getMessage(bindingMessageReference.getInterfaceMessageReference().getMessageLabel().toString());
                axisBindingMessage.setAxisMessage(axisMessage);
                axisBindingMessage.setName(axisMessage.getName());
                axisBindingMessage.setDirection(axisMessage.getDirection());
                try {
                    soapBindingMessageReferenceExtensions = (SOAPBindingMessageReferenceExtensions)bindingMessageReference.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("Soap Binding Extention not found");
                }
                axisBindingMessage.setProperty("whttp:header", this.createHttpHeaders(soapBindingMessageReferenceExtensions.getHttpHeaders()));
                axisBindingMessage.setProperty("whttp:contentEncoding", soapBindingMessageReferenceExtensions.getHttpContentEncoding());
                axisBindingMessage.setProperty("wsoap:header", this.createSoapHeaders(soapBindingMessageReferenceExtensions.getSoapHeaders()));
                axisBindingMessage.setProperty("wsoap:module", this.createSoapModules(soapBindingMessageReferenceExtensions.getSoapModules()));
                axisBindingOperation.addChild(axisMessage.getDirection(), axisBindingMessage);
            }
            BindingFaultReference[] bindingFaultReferences = bindingOperation.getBindingFaultReferences();
            for (int j = 0; j < bindingFaultReferences.length; ++j) {
                SOAPBindingFaultReferenceExtensions soapBindingFaultReferenceExtensions;
                BindingFaultReference bindingFaultReference = bindingFaultReferences[j];
                AxisBindingMessage axisBindingMessageFault = new AxisBindingMessage();
                this.addDocumentation(axisBindingMessageFault, (DocumentableElement)bindingFaultReference.toElement());
                axisBindingMessageFault.setParent(axisBindingOperation);
                axisBindingMessageFault.setFault(true);
                axisBindingMessageFault.setName(bindingFaultReference.getInterfaceFaultReference().getInterfaceFault().getName().getLocalPart());
                try {
                    soapBindingFaultReferenceExtensions = (SOAPBindingFaultReferenceExtensions)bindingFaultReference.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/soap"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("Soap Binding Extention not found");
                }
                axisBindingMessageFault.setProperty("wsoap:module", this.createSoapModules(soapBindingFaultReferenceExtensions.getSoapModules()));
                axisBindingOperation.addFault(axisBindingMessageFault);
            }
            axisBinding.setProperty("HTTPLocationTable", httpLocationTable);
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
    }

    private void processHTTPBindingExtention(Binding binding, AxisBinding axisBinding, Interface serviceInterface) throws AxisFault {
        HTTPBindingExtensions httpBindingExtensions;
        Map<String, AxisOperation> httpLocationTable = this.createHttpLocationTable();
        try {
            httpBindingExtensions = (HTTPBindingExtensions)binding.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/http"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("HTTP Binding Extention not found");
        }
        String httpMethodDefault = httpBindingExtensions.getHttpMethodDefault();
        axisBinding.setProperty("whttp:method", httpMethodDefault);
        axisBinding.setProperty("whttp:queryParameterSeparator", httpBindingExtensions.getHttpQueryParameterSeparatorDefault());
        axisBinding.setProperty("whttp:contentEncoding", httpBindingExtensions.getHttpContentEncodingDefault());
        BindingFault[] bindingFaults = binding.getBindingFaults();
        for (int i = 0; i < bindingFaults.length; ++i) {
            HTTPBindingFaultExtensions httpBindingFaultExtensions;
            BindingFault bindingFault = bindingFaults[i];
            InterfaceFault interfaceFault = serviceInterface.getFromAllInterfaceFaults(((BindingFaultElement)bindingFault).getRef());
            AxisBindingMessage axisBindingFault = new AxisBindingMessage();
            axisBindingFault.setFault(true);
            axisBindingFault.setName(interfaceFault.getName().getLocalPart());
            axisBindingFault.setParent(axisBinding);
            this.addDocumentation(axisBindingFault, (DocumentableElement)interfaceFault.toElement());
            try {
                httpBindingFaultExtensions = (HTTPBindingFaultExtensions)bindingFault.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/http"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("HTTP Binding Extention not found");
            }
            axisBindingFault.setProperty("whttp:code", httpBindingFaultExtensions.getHttpErrorStatusCode().getCode());
            axisBindingFault.setProperty("whttp:header", this.createHttpHeaders(httpBindingFaultExtensions.getHttpHeaders()));
            axisBindingFault.setProperty("whttp:contentEncoding", httpBindingFaultExtensions.getHttpContentEncoding());
            axisBinding.addFault(axisBindingFault);
        }
        BindingOperation[] bindingOperations = binding.getBindingOperations();
        for (int i = 0; i < bindingOperations.length; ++i) {
            HTTPBindingOperationExtensions httpBindingOperationExtensions;
            BindingOperation bindingOperation = bindingOperations[i];
            AxisBindingOperation axisBindingOperation = new AxisBindingOperation();
            InterfaceOperation interfaceOperation = serviceInterface.getFromAllInterfaceOperations(((BindingOperationElement)bindingOperation).getRef());
            AxisOperation axisOperation = this.axisService.getOperation(interfaceOperation.getName());
            axisBindingOperation.setAxisOperation(axisOperation);
            axisBindingOperation.setParent(axisBinding);
            axisBindingOperation.setName(axisOperation.getName());
            this.addDocumentation(axisBindingOperation, (DocumentableElement)bindingOperation.toElement());
            try {
                httpBindingOperationExtensions = (HTTPBindingOperationExtensions)bindingOperation.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/http"));
            }
            catch (URISyntaxException e) {
                throw new AxisFault("HTTP Binding Extention not found");
            }
            axisBindingOperation.setProperty("whttp:faultSerialization", httpBindingOperationExtensions.getHttpFaultSerialization());
            axisBindingOperation.setProperty("whttp:inputSerialization", httpBindingOperationExtensions.getHttpInputSerialization());
            String httpMethod = httpBindingOperationExtensions.getHttpMethod();
            if (httpMethod == null) {
                Boolean safeParameter;
                httpMethod = httpMethodDefault != null ? httpMethodDefault : ((safeParameter = (Boolean)axisOperation.getParameterValue("wsdlx:safe")) != null && safeParameter != false ? "GET" : "POST");
            }
            axisBindingOperation.setProperty("whttp:method", httpMethod);
            HTTPLocation httpLocation = httpBindingOperationExtensions.getHttpLocation();
            String httpLocationString = "";
            if (httpLocation != null) {
                String httpLocationTemplete = httpLocation.getOriginalLocation();
                axisBindingOperation.setProperty("whttp:location", httpLocationTemplete);
                httpLocationString = WSDLUtil.getConstantFromHTTPLocation(httpLocationTemplete, httpMethod);
            }
            httpLocationTable.put(httpLocationString, axisOperation);
            axisBindingOperation.setProperty("whttp:ignoreUncited", httpBindingOperationExtensions.isHttpLocationIgnoreUncited());
            axisBindingOperation.setProperty("whttp:outputSerialization", httpBindingOperationExtensions.getHttpOutputSerialization());
            axisBindingOperation.setProperty("whttp:queryParameterSeparator", httpBindingOperationExtensions.getHttpQueryParameterSeparator());
            axisBindingOperation.setProperty("whttp:contentEncoding", httpBindingOperationExtensions.getHttpContentEncodingDefault());
            BindingMessageReference[] bindingMessageReferences = bindingOperation.getBindingMessageReferences();
            for (int j = 0; j < bindingMessageReferences.length; ++j) {
                HTTPBindingMessageReferenceExtensions httpBindingMessageReferenceExtensions;
                BindingMessageReference bindingMessageReference = bindingMessageReferences[j];
                AxisBindingMessage axisBindingMessage = new AxisBindingMessage();
                axisBindingMessage.setParent(axisBindingOperation);
                AxisMessage axisMessage = axisOperation.getMessage(bindingMessageReference.getInterfaceMessageReference().getMessageLabel().toString());
                axisBindingMessage.setAxisMessage(axisMessage);
                axisBindingMessage.setName(axisMessage.getName());
                axisBindingMessage.setDirection(axisMessage.getDirection());
                this.addDocumentation(axisBindingMessage, (DocumentableElement)bindingMessageReference.toElement());
                try {
                    httpBindingMessageReferenceExtensions = (HTTPBindingMessageReferenceExtensions)bindingMessageReference.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/http"));
                }
                catch (URISyntaxException e) {
                    throw new AxisFault("HTTP Binding Extention not found");
                }
                axisBindingMessage.setProperty("whttp:header", this.createHttpHeaders(httpBindingMessageReferenceExtensions.getHttpHeaders()));
                axisBindingMessage.setProperty("whttp:contentEncoding", httpBindingMessageReferenceExtensions.getHttpContentEncoding());
                axisBindingOperation.addChild("In", axisBindingMessage);
            }
            BindingFaultReference[] bindingFaultReferences = bindingOperation.getBindingFaultReferences();
            for (int j = 0; j < bindingFaultReferences.length; ++j) {
                BindingFaultReference bindingFaultReference = bindingFaultReferences[j];
                AxisBindingMessage axisBindingMessageFault = new AxisBindingMessage();
                axisBindingMessageFault.setFault(true);
                axisBindingMessageFault.setName(bindingFaultReference.getInterfaceFaultReference().getInterfaceFault().getName().getLocalPart());
                axisBindingMessageFault.setParent(axisBindingOperation);
                axisBindingOperation.addFault(axisBindingMessageFault);
                this.addDocumentation(axisBindingMessageFault, (DocumentableElement)bindingFaultReference.toElement());
            }
            axisBinding.setProperty("HTTPLocationTable", httpLocationTable);
            axisBinding.addChild(axisBindingOperation.getName(), axisBindingOperation);
        }
    }

    private void processInterface(Interface serviceInterface) throws AxisFault {
        InterfaceOperation[] interfaceOperations = serviceInterface.getInterfaceOperations();
        for (int i = 0; i < interfaceOperations.length; ++i) {
            this.axisService.addOperation(this.populateOperations(interfaceOperations[i]));
            this.operationNames.add(interfaceOperations[i].getName());
        }
        Interface[] extendedInterfaces = serviceInterface.getExtendedInterfaces();
        for (int i = 0; i < extendedInterfaces.length; ++i) {
            Interface extendedInterface = extendedInterfaces[i];
            this.processInterface(extendedInterface);
        }
    }

    private AxisOperation populateOperations(InterfaceOperation operation) throws AxisFault {
        RPCInterfaceOperationExtensions rpcInterfaceOperationExtensions;
        InterfaceOperationExtensions interfaceOperationExtensions;
        URI[] operationStyle;
        QName opName = operation.getName();
        AxisOperation axisOperation = this.axisService.getOperation(opName);
        if (axisOperation == null) {
            URI pattern = operation.getMessageExchangePattern();
            String MEP = pattern == null ? WSDL20DefaultValueHolder.getDefaultValue("wsoap:mep") : pattern.toString();
            if (!this.isServerSide) {
                if ("http://www.w3.org/ns/wsdl/in-out".equals(MEP)) {
                    MEP = "http://www.w3.org/ns/wsdl/out-in";
                }
                if ("http://www.w3.org/ns/wsdl/in-only".equals(MEP)) {
                    MEP = "http://www.w3.org/ns/wsdl/out-only";
                }
                if ("http://www.w3.org/ns/wsdl/in-opt-out".equals(MEP)) {
                    MEP = "http://www.w3.org/ns/wsdl/out-opt-in";
                }
            }
            axisOperation = AxisOperationFactory.getOperationDescription(MEP);
            axisOperation.setName(opName);
        }
        if ((operationStyle = operation.getStyle()) != null && operationStyle.length > 0) {
            Parameter opStyleParameter = new Parameter();
            opStyleParameter.setName("operationStyle");
            opStyleParameter.setValue(operationStyle);
            axisOperation.addParameter(opStyleParameter);
        }
        this.addDocumentation(axisOperation, (DocumentableElement)operation.toElement());
        try {
            interfaceOperationExtensions = (InterfaceOperationExtensions)operation.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl-extensions"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("WSDL2 extensions not defined for this operation");
        }
        if (interfaceOperationExtensions != null) {
            Parameter parameter = new Parameter("wsdlx:safe", interfaceOperationExtensions.isSafe());
            axisOperation.addParameter(parameter);
        }
        try {
            rpcInterfaceOperationExtensions = (RPCInterfaceOperationExtensions)operation.getComponentExtensionContext(new URI("http://www.w3.org/ns/wsdl/rpc"));
        }
        catch (URISyntaxException e) {
            throw new AxisFault("WSDL2 extensions not defined for this operation");
        }
        if (rpcInterfaceOperationExtensions != null) {
            String rpcsig = "";
            Argument[] signatures = rpcInterfaceOperationExtensions.getRPCSignature();
            for (int i = 0; i < signatures.length; ++i) {
                Argument sigArgument = signatures[i];
                rpcsig = rpcsig + sigArgument.getName().getLocalPart() + " " + sigArgument.getDirection() + " ";
            }
            Parameter parameter = new Parameter("wrpc:signature", rpcsig);
            axisOperation.addParameter(parameter);
        }
        InterfaceMessageReference[] interfaceMessageReferences = operation.getInterfaceMessageReferences();
        for (int i = 0; i < interfaceMessageReferences.length; ++i) {
            InterfaceMessageReference messageReference = interfaceMessageReferences[i];
            if (messageReference.getMessageLabel().equals((Object)MessageLabel.IN)) {
                if (this.isServerSide) {
                    this.createAxisMessage(axisOperation, messageReference, "In");
                    continue;
                }
                this.createAxisMessage(axisOperation, messageReference, "Out");
                continue;
            }
            if (!messageReference.getMessageLabel().equals((Object)MessageLabel.OUT)) continue;
            if (this.isServerSide) {
                this.createAxisMessage(axisOperation, messageReference, "Out");
                continue;
            }
            this.createAxisMessage(axisOperation, messageReference, "In");
        }
        InterfaceFaultReference[] faults = operation.getInterfaceFaultReferences();
        for (int i = 0; i < faults.length; ++i) {
            AxisMessage faultMessage = new AxisMessage();
            InterfaceFaultReference interfaceFaultReference = faults[i];
            faultMessage.setDirection(interfaceFaultReference.getDirection().toString());
            InterfaceFault interfaceFault = interfaceFaultReference.getInterfaceFault();
            if (interfaceFault == null) {
                throw new AxisFault("Interface Fault reference defined in operation " + opName + " cannot be found in interface");
            }
            InterfaceFaultElement interfaceFaultElement = interfaceFault.toElement();
            QNameTokenUnion interfaceFaultElementDef = interfaceFaultElement.getElement();
            QName qName = interfaceFaultElementDef.getQName();
            String name = qName.getLocalPart();
            faultMessage.setElementQName(qName);
            faultMessage.setName(name);
            axisOperation.setFaultMessages(faultMessage);
        }
        return axisOperation;
    }

    private void createAxisMessage(AxisOperation axisOperation, InterfaceMessageReference messageReference, String messageLabel) throws AxisFault {
        XMLAttr xa;
        AxisMessage message = axisOperation.getMessage(messageLabel);
        String messageContentModelName = messageReference.getMessageContentModel();
        QName elementQName = null;
        if ("#element".equals(messageContentModelName)) {
            ElementDeclaration elementDeclaration = messageReference.getElementDeclaration();
            if (elementDeclaration == null) {
                InterfaceMessageReferenceElement messageReferenceElement = messageReference.toElement();
                QName qName = messageReferenceElement.getElement().getQName();
                throw new AxisFault("Unable to find element " + qName.toString() + " reffered to by operation " + axisOperation.getName().getLocalPart());
            }
            elementQName = elementDeclaration.getName();
        } else if ("#any".equals(messageContentModelName)) {
            elementQName = Constants.XSD_ANY;
        } else if (!"#none".equals(messageContentModelName)) {
            throw new AxisFault("Sorry we do not support " + messageContentModelName + ". We do only support #any, #none and #element as message content models.");
        }
        message.setElementQName(elementQName);
        message.setName(elementQName != null ? elementQName.getLocalPart() : axisOperation.getName().getLocalPart());
        axisOperation.addMessage(message, messageLabel);
        if ("In".equals(messageLabel)) {
            String value;
            xa = messageReference.toElement().getExtensionAttribute(new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action"));
            if (xa != null && (value = (String)xa.getContent()) != null) {
                ArrayList<String> al = axisOperation.getWSAMappingList();
                if (al == null) {
                    al = new ArrayList();
                    axisOperation.setWsamappingList(al);
                }
                al.add(value);
            }
        } else {
            String value;
            xa = messageReference.toElement().getExtensionAttribute(new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action"));
            if (xa != null && (value = (String)xa.getContent()) != null) {
                axisOperation.setOutputAction(value);
            }
        }
        if (elementQName != null) {
            this.axisService.addMessageElementQNameToOperationMapping(elementQName, axisOperation);
        }
    }

    private Description readInTheWSDLFile(String wsdlURI) throws WSDLException, AxisFault {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(wsdlURI);
        }
        catch (ParserConfigurationException e) {
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        catch (SAXException e) {
            throw AxisFault.makeFault(e);
        }
        return this.readInTheWSDLFile(document);
    }

    private Description readInTheWSDLFile(InputStream inputStream) throws WSDLException, AxisFault {
        Document document;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(inputStream);
        }
        catch (ParserConfigurationException e) {
            throw AxisFault.makeFault(e);
        }
        catch (IOException e) {
            throw AxisFault.makeFault(e);
        }
        catch (SAXException e) {
            throw AxisFault.makeFault(e);
        }
        return this.readInTheWSDLFile(document);
    }

    private Description readInTheWSDLFile(Document document) throws WSDLException {
        WSDLFactory factory = WSDLFactory.newInstance();
        WSDLReader reader = factory.newWSDLReader();
        if (this.customWSDLResolver != null) {
            reader.setURIResolver(this.customWSDLResolver);
        }
        reader.setFeature("http://ws.apache.org/woden/features/validation", true);
        WSDLSource wsdlSource = reader.createWSDLSource();
        wsdlSource.setSource((Object)document.getDocumentElement());
        String uri = this.getBaseUri();
        if (uri != null && !"".equals(uri)) {
            try {
                wsdlSource.setBaseURI(new URI(uri));
            }
            catch (URISyntaxException e) {
                File f = new File(uri);
                if (f.exists()) {
                    wsdlSource.setBaseURI(f.toURI());
                }
                log.error((Object)e.toString(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading 2.0 WSDL with wsdl uri = " + this.wsdlURI));
            log.trace((Object)("  the stack at this point is: " + WSDL20ToAxisServiceBuilder.stackToString()));
        }
        return reader.readWSDL(wsdlSource);
    }

    private List<SOAPHeaderMessage> createSoapHeaders(SOAPHeaderBlock[] soapHeaderBlocks) {
        if (soapHeaderBlocks.length == 0) {
            return null;
        }
        ArrayList<SOAPHeaderMessage> soapHeaderMessages = new ArrayList<SOAPHeaderMessage>();
        for (int i = 0; i < soapHeaderBlocks.length; ++i) {
            SOAPHeaderBlock soapHeaderBlock = soapHeaderBlocks[i];
            ElementDeclaration elementDeclaration = soapHeaderBlock.getElementDeclaration();
            if (elementDeclaration == null) continue;
            QName name = elementDeclaration.getName();
            SOAPHeaderMessage soapHeaderMessage = new SOAPHeaderMessage();
            soapHeaderMessage.setElement(name);
            soapHeaderMessage.setRequired(soapHeaderBlock.isRequired());
            soapHeaderMessage.setMustUnderstand(soapHeaderBlock.mustUnderstand());
            soapHeaderMessages.add(soapHeaderMessage);
        }
        return soapHeaderMessages;
    }

    private List<SOAPModuleMessage> createSoapModules(SOAPModule[] soapModules) {
        if (soapModules.length == 0) {
            return null;
        }
        ArrayList<SOAPModuleMessage> soapModuleMessages = new ArrayList<SOAPModuleMessage>();
        for (int i = 0; i < soapModules.length; ++i) {
            SOAPModule soapModule = soapModules[i];
            SOAPModuleMessage soapModuleMessage = new SOAPModuleMessage();
            soapModuleMessage.setUri(soapModule.getRef().toString());
            soapModuleMessages.add(soapModuleMessage);
        }
        return soapModuleMessages;
    }

    private List<HTTPHeaderMessage> createHttpHeaders(HTTPHeader[] httpHeaders) {
        if (httpHeaders.length == 0) {
            return null;
        }
        ArrayList<HTTPHeaderMessage> httpHeaderMessages = new ArrayList<HTTPHeaderMessage>();
        for (int i = 0; i < httpHeaders.length; ++i) {
            HTTPHeader httpHeader = httpHeaders[i];
            HTTPHeaderMessage httpHeaderMessage = new HTTPHeaderMessage();
            httpHeaderMessage.setqName(((HTTPHeaderElement)httpHeader).getTypeName());
            httpHeaderMessage.setName(httpHeader.getName());
            httpHeaderMessage.setRequired(httpHeader.isRequired());
            httpHeaderMessages.add(httpHeaderMessage);
        }
        return httpHeaderMessages;
    }

    private void addDocumentation(AxisDescription axisDescription, DocumentableElement element) {
        DocumentationElement[] documentationElements = element.getDocumentationElements();
        String documentation = "";
        for (int i = 0; i < documentationElements.length; ++i) {
            DocumentationElement documentationElement = documentationElements[i];
            XMLElement contentElement = documentationElement.getContent();
            Element content = (Element)contentElement.getSource();
            if (content == null) continue;
            documentation = documentation + DOM2Writer.nodeToString((Node)content.getFirstChild());
        }
        if (!"".equals(documentation)) {
            axisDescription.setDocumentation(documentation);
        }
    }

    private void setEndpointURL(AxisEndpoint axisEndpoint, String endpointURL) {
        axisEndpoint.setEndpointURL(endpointURL);
        try {
            URL url = new URL(endpointURL);
            axisEndpoint.setTransportInDescription(url.getProtocol());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
        }
    }
}

