#!/usr/bin/env groovy
/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool
import com.urbancode.air.XTrustProvider
import org.apache.commons.httpclient.HttpClient

import org.apache.commons.httpclient.UsernamePasswordCredentials
import org.apache.commons.httpclient.auth.AuthScope
import org.apache.commons.httpclient.methods.GetMethod

def apTool = new AirPluginTool(args[0], args[1]);
def props = apTool.getStepProperties();

def String urlString = props['nolioURL']?.trim()
def String nolioUsername = props['nolioUsername']?.trim()
def String nolioPassword = props['nolioPassword']?.trim()
def GetMethod get

if (!urlString.endsWith("/")) {
    urlString += "/"
}

urlString += 'datamanagement/ws/OpenAPIService?wsdl'

try {
    XTrustProvider.install()
    def URL url = new URL(urlString)

    def client = new HttpClient()
    client.getParams().setAuthenticationPreemptive(true)
    client.getState().setCredentials(
            new AuthScope(url.getHost(), url.getPort(), null),
            new UsernamePasswordCredentials(nolioUsername, nolioPassword)
    )

    get = new GetMethod(urlString)
    get.setDoAuthentication(true)

    println "CA Release Automation connection check URL: $urlString"
    int returnCode = client.executeMethod(get)
    println "Return code: $returnCode"
    if (returnCode == 401) {
        throw new RuntimeException("Failed to authenticate")
    }
    else if (returnCode < 200 || returnCode > 299) {
        throw new RuntimeException("Invalid URL")
    }

    println "IBM UrbanCode Release was able to connect to the CA Release Automation Server"
}
catch (Exception e) {
    println "Unable to connect to CA Release Automation"

    println "-----------------------------------------";
    println "Exception:";
    println e;
    println "Cause:";
    println e.cause;
    println "-----------------------------------------";
    throw new RuntimeException();
}
finally {
    if (get != null) {
        get.releaseConnection()
    }
}