#!/usr/bin/env groovy

/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Release
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */
import com.nolio.platform.server.dataservices.api.model.OpenAPIServiceStub.GetAssignedProcessesForEnvironmentResponse
import com.urbancode.commons.util.environment.Environment
import com.urbancode.release.rest.models.Application
import com.urbancode.release.rest.models.Component
import com.urbancode.release.rest.models.ComponentVersion
import com.urbancode.release.rest.models.Inventory
import com.urbancode.release.rest.models.Version
import com.urbancode.release.rest.models.internal.Comment
import com.urbancode.release.rest.models.internal.TaskExecution
import com.urbancode.release.rest.models.internal.ApplicationEnvironment
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider

import com.nolio.platform.server.dataservices.api.model.OpenAPIServiceStub
import com.urbancode.air.*
import com.urbancode.release.rest.framework.Clients
import com.urbancode.release.rest.models.internal.Task.TaskType
import com.urbancode.release.rest.models.internal.TaskPlan
import com.urbancode.urelease.integration.nolio.NolioRestAPIHelper
import com.urbancode.urelease.integration.nolio.NolioIntegration
import com.urbancode.urelease.integration.nolio.sync.FullSyncClient
import com.urbancode.urelease.integration.nolio.sync.SyncClient
import com.urbancode.urelease.integration.nolio.sync.TaskPlanFullSyncClient
import org.apache.log4j.*
import groovy.util.logging.*
import java.util.concurrent.TimeUnit
import java.util.Map.Entry
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.JsonArray

final def workDir = new File('.').canonicalFile

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

//We launch the integration here
def integration = new NolioIntegration (props)

def totalStart = System.currentTimeMillis()
//We authenticate with IBM UrbanCode Release
integration.releaseAuthentication ()
//We launch the full Integration
integration.runIntegration ()

def totalEnd = System.currentTimeMillis()
