package com.urbancode.urelease.integration.nolio.sync

import com.urbancode.release.rest.models.internal.TaskPlan
import com.urbancode.release.rest.framework.QueryParams.FilterClass
import com.urbancode.commons.util.query.QueryFilter.FilterType
import com.google.common.collect.Lists

/*
 * A special sync client to handle how TaskPlans should be deleted.
 */
class TaskPlanFullSyncClient extends FullSyncClient<TaskPlan> {

    public TaskPlanFullSyncClient(TaskPlan syncObject, int syncMax, String providerId) {
        super(syncObject, syncMax, providerId)
    }

    @Override
    public void addImport(TaskPlan newImport) {
        importList.add(newImport)

        if (importList.size() >= syncMax) {
            syncImports()
        }

        /* If this is the first import being added, initialize the deleteList */
        if (deleteList == null) {
            deleteList = syncObject.filter("integrationProvider.id",
                FilterClass.UUID, FilterType.EQUALS, providerId).filter("template",
                FilterClass.BOOLEAN, FilterType.EQUALS, true).when().getAll()
        }

        for (TaskPlan delete : deleteList) {
            if (delete.externalId.equals(newImport.externalId)) {
                /* The import still exists in Nolio, so don't remove it from UCR */
                deleteList.remove(delete)
                break
            }
        }
    }

    @Override
    public void syncRemovals() {
        if (deleteList?.size() > 0) {
            List<List<TaskPlan>> partitionedLists = Lists.partition(deleteList, syncMax)
            for (List<TaskPlan> list : partitionedLists) {
                for (TaskPlan taskPlan : list) {
                    taskPlan.active(false)
                }

                // Deactivate TaskPlans
                List<TaskPlan> deactivated = syncObject.sync(list)
                removalCount += deactivated.size()
            }
        }
    }
}
