/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air

import java.text.SimpleDateFormat

import com.urbancode.commons.util.query.QueryFilter.FilterType;
import com.urbancode.release.rest.framework.QueryParams.FilterClass;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.PluginIntegrationProvider;

public class CRMapper {

    private PluginIntegrationProvider provider
    def slurper = new groovy.json.JsonSlurper()

    public CRMapper(PluginIntegrationProvider provider) {
        this.provider = provider
    }

    public def addRecord(sdId, crId) {
        provider = provider.get();
        def existingMap = provider.getProperty("crMapping");

        def mappingStore = []
        if (existingMap != null) {
            mappingStore = slurper.parseText(existingMap);
        }

        def mappingRecord = [id: sdId, cr: crId];
        mappingStore.add(mappingRecord);
        provider.property("crMapping", new groovy.json.JsonBuilder(mappingStore).toString())

        provider.save();
    }

    public def hasCRForSD(sdId) {
        provider = provider.get();
        def existingMap = provider.getProperty("crMapping");

        def mappingStore = []
        if (existingMap != null) {
            mappingStore = slurper.parseText(existingMap);
        }

        def result = null;

        mappingStore.each { mappingItem ->
            if (mappingItem.id.equals(sdId)) {
                result = mappingItem.cr
            }
        }

        return result
    }


    public def getSDForCR(crId) {
        provider = provider.get();
        def existingMap = provider.getProperty("crMapping");

        def mappingStore = []

        if (existingMap != null) {
            mappingStore = slurper.parseText(existingMap);
        }

        def result = null;

        mappingStore.each { mappingItem ->
            if (mappingItem.cr.equals(crId)) {
                result = mappingItem.id
            }
        }

        return result
    }

    public def hasSD(sdId) {
        def crId = hasCRForSD(sdId);

        return (crId != null)
    }

    public def removeSD(sdId) {
        provider = provider.get();
        def existingMap = provider.getProperty("crMapping");

        def mappingStore = []
        if (existingMap != null) {
            mappingStore = slurper.parseText(existingMap);
        }

        def result = [];

        mappingStore.each { mappingItem ->
            if (!mappingItem.id.equals(sdId)) {
                result << mappingItem
            }
        }

        provider.property("crMapping", new groovy.json.JsonBuilder(result).toString())
        provider.save();
    }
}