/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air

import java.text.SimpleDateFormat
import com.urbancode.release.rest.models.internal.TaskExecution;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import org.apache.commons.lang3.StringUtils;

public class PropsParser {

    public parse(String pluginProps) {
        return parse(pluginProps, null, null)
    }
    
    public parse(String pluginProps, ScheduledDeployment sd, TaskExecution task) {
        return parse(pluginProps, null, sd, task)
    }

    public parse(String pluginProps, Map extraData, ScheduledDeployment sd, TaskExecution task) {
        def result = [:]

        if(pluginProps == null) {
            return result;
        }
        
        def pluginPropLines = pluginProps.split("\n")

        pluginPropLines.each{ line ->
            def keyValue = line.split("=", 2);
            if (keyValue.size() > 1) {
                def key = keyValue[0]
                def value = keyValue[1]

                if(key != null && !key.equals("") && value != null && !value.equals("")) {

                    value = evaluatePropsToReplace(value, extraData, sd, task)
                    println "PARSE KEY ---> " + key
                    println "PARSE VALUE ---> " + value
                    result[key] = value;
                }
            }
        }
        return result
    }
    
    public parseSingleValue(String value, Map extraData, ScheduledDeployment sd, TaskExecution task) {
        def result;

        if(value == null) {
            return result;
        }

        if(value != null && !value.equals("")) {
            result = evaluatePropsToReplace(value, extraData, sd, task)
            println "PARSE SINGLE VALUE ---> " + result
        }
        
        return result
    }

    private String evaluatePropsToReplace(String input, Map extraData, ScheduledDeployment sd, TaskExecution task) {
        def propsToReplace = StringUtils.substringsBetween(input, "\${", "}");

        propsToReplace.each{ propToReplace -> 
            def tokens = propToReplace.split("\\.")
            def obj = null;

            if(tokens.length > 0 && tokens[0] == "sd" && sd) {
                obj = sd;
            }
            if(tokens.length > 0 && tokens[0] == "task" && task) {
                obj = task;
            }
            if (obj) {
                for(int i = 1; i < tokens.length; i++) {
                    if(obj.hasProperty(tokens[i])) {
                        obj = obj[tokens[i]];
                    } else {
                         if (extraData) {
                              if (extraData[tokens[i]]) {
                                 obj = extraData[tokens[i]];
                              }else {
                             println "Could not resolve property " + propToReplace
                             return input
                         }
                          }
                          else {
                             println "Could not resolve property " + propToReplace
                             return input
                         }
                    }
                }
                def resolvedValue = "";
                if (obj != null && obj.toString() != null) {
                    resolvedValue = obj.toString();
                }
                input = input.replaceAll("\\" + "\$" + "\\" + "{" + propToReplace + "\\" + "}", resolvedValue)
            }
        }

        return input
    }
}