/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.internal.MilestoneTemplate;

public class ProcessChecklistTemplate
extends ClientDescribed<ProcessChecklistTemplate> {
    @JsonReadOnly
    public MilestoneTemplate[] templates;

    public ProcessChecklistTemplate() {
        this.path = "/milestoneSequence/";
    }

    public ProcessChecklistTemplate applyTo(Release release) {
        RestAssured.given().body((Object)new ChecklistApply(this.id, release.targetDate), ObjectMapperType.GSON).post(this.path() + "createFor/" + release.id, new Object[0]);
        return this;
    }

    public ProcessChecklistTemplate[] getAllFilterable() {
        log.debug("getAllWithPath()");
        return (ProcessChecklistTemplate[])this.getAllWithPath("/processChecklists/").as(this.arrayClass(), ObjectMapperType.GSON);
    }

    public static class ChecklistApply {
        public String template;
        public Long targetDate;

        public ChecklistApply(String template, Long targetDate) {
            this.template = template;
            this.targetDate = targetDate;
        }
    }
}

