/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2014. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.TaskExecution;
import com.urbancode.air.*
import com.urbancode.plugin.*;

public class UCRPropsUtil {

    //This methods can be used to provide other set of properties that might require 
    //more work to fetch or build
    public getExtraProperties(Object stepProperties, ScheduledDeployment sd, TaskExecution task) {
    
        def extraData = [:];
        def slurper = new groovy.json.JsonSlurper()
        def extraProperties = stepProperties['extraProperties']
        def currentTaskExtra = slurper.parseText(extraProperties)
        def serverUrl = stepProperties['releaseServerUrl'];
	

        if (sd != null) {
	
	         def sdLink = serverUrl+"/scheduledDeployment/"+sd.id+"#execution ";
	        def applicationList="";
	
	        sd.versions.each {
	           app-> applicationList+=" [" + app.application.name+" - "+app.appVersion.name + "] ";
	        }   
	        	        
	        //List of applications and versions
	        if (applicationList != "") {
	            extraData.appAndVersions = applicationList;
	        }
	        else {
	            extraData.appAndVersions = "[No Versions]";
	        }
	        
	        //A direct link to the UCR Deployment
	        extraData.link = sdLink;
	       
	        
	        if (currentTaskExtra.scheduledDeployment != null) extraData.displayName = currentTaskExtra.scheduledDeployment.name;
        }
        
       
        if (task != null && currentTaskExtra.task != null && currentTaskExtra.task.taskUrl != null) {
            def taskLink = serverUrl+"/"+currentTaskExtra.task.taskUrl;

            extraData.taskLink = taskLink;
        }
        else if(currentTaskExtra.taskUrl != null) {
            extraData.taskLink = currentTaskExtra.taskUrl;
        }
    
        return extraData;
    }

 
}