/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.tfs

import com.microsoft.tfs.core.clients.workitem.node.*

public class NodeParser {
    private def childChildNodes
    private def childNodes
    private Map item
    private MapBuilder mappy = new MapBuilder()

    public String getJSONString() {
        return mappy.getJSONString()
    }

    // Recursively parses nodes
    public void parseNodes(childNodes) {
        childNodes.each { node ->
            mappy.set(node.getPath(),node.getID())
            childChildNodes = node.getChildNodes()
            if (childChildNodes) {
                parseNodes(childChildNodes)
            }
        }
    }
}
