/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.restassured.builder;

import com.jayway.restassured.internal.MultiPartSpecificationImpl;
import com.jayway.restassured.specification.MultiPartSpecification;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.commons.lang3.Validate;

public class MultiPartSpecBuilder {
    private Object content;
    private String controlName;
    private String mimeType;
    private String charset;
    private String fileName;

    public MultiPartSpecBuilder(Object content) {
        Validate.notNull(content, "Multi-part content cannot be null", new Object[0]);
        this.content = content;
        this.controlName = "file";
    }

    public MultiPartSpecBuilder(InputStream content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(String content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(byte[] content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder(File content) {
        this((Object)content);
    }

    public MultiPartSpecBuilder controlName(String controlName) {
        Validate.notEmpty(controlName, "Control name cannot be empty", new Object[0]);
        this.controlName = controlName;
        return this;
    }

    public MultiPartSpecBuilder fileName(String fileName) {
        Validate.notEmpty(fileName, "File name cannot be empty", new Object[0]);
        if (!(this.content instanceof File || this.content instanceof byte[] || this.content instanceof InputStream)) {
            throw new IllegalArgumentException(String.format("Cannot specify file name for non file content (%s).", this.content.getClass().getName()));
        }
        this.fileName = fileName;
        return this;
    }

    public MultiPartSpecBuilder mimeType(String mimeType) {
        Validate.notEmpty(mimeType, "Mime-type cannot be empty", new Object[0]);
        this.mimeType = mimeType;
        return this;
    }

    public MultiPartSpecBuilder charset(String charset) {
        Validate.notEmpty(charset, "Charset cannot be empty", new Object[0]);
        if (this.content instanceof byte[] || this.content instanceof InputStream) {
            throw new IllegalArgumentException(String.format("Cannot specify charset input streams or byte arrays.", new Object[0]));
        }
        this.charset = charset;
        return this;
    }

    public MultiPartSpecBuilder with() {
        return this;
    }

    public MultiPartSpecBuilder and() {
        return this;
    }

    public MultiPartSpecBuilder charset(Charset charset) {
        Validate.notNull(charset, "Charset cannot be null", new Object[0]);
        this.charset = charset.toString();
        return this;
    }

    public MultiPartSpecification build() {
        MultiPartSpecificationImpl spec = new MultiPartSpecificationImpl();
        spec.setCharset(this.charset);
        spec.setContent(this.content);
        spec.setControlName(this.controlName);
        spec.setFileName(this.fileName);
        spec.setMimeType(this.mimeType);
        return spec;
    }
}

